/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import org.apache.camel.component.http.HttpClientConfigurer;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.auth.AuthScope;

public class NTLMAuthenticationHttpClientConfigurer
implements HttpClientConfigurer {
    private final boolean proxy;
    private final String username;
    private final String password;
    private final String domain;
    private final String host;

    public NTLMAuthenticationHttpClientConfigurer(boolean proxy, String user, String pwd, String domain, String host) {
        this.proxy = proxy;
        this.username = user;
        this.password = pwd;
        this.domain = domain;
        this.host = host;
    }

    @Override
    public void configureHttpClient(HttpClient client) {
        NTCredentials credentials = new NTCredentials(this.username, this.password, this.host, this.domain);
        if (this.proxy) {
            client.getState().setProxyCredentials(AuthScope.ANY, (Credentials)credentials);
        } else {
            client.getState().setCredentials(AuthScope.ANY, (Credentials)credentials);
        }
    }

    public boolean isProxy() {
        return this.proxy;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getHost() {
        return this.host;
    }
}

