/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SocketChannel;
import java.util.regex.Pattern;
import jnr.constants.platform.AddressFamily;
import jnr.constants.platform.INAddr;
import jnr.constants.platform.IPProto;
import jnr.constants.platform.NameInfo;
import jnr.constants.platform.ProtocolFamily;
import jnr.constants.platform.Shutdown;
import jnr.constants.platform.Sock;
import jnr.constants.platform.SocketLevel;
import jnr.constants.platform.SocketOption;
import jnr.constants.platform.TCP;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketChannel;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.socket.Addrinfo;
import org.jruby.ext.socket.RubyBasicSocket;
import org.jruby.ext.socket.RubyServerSocket;
import org.jruby.ext.socket.SocketUtils;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.ModeFlags;
import org.jruby.util.io.Sockaddr;

@JRubyClass(name={"Socket"}, parent="BasicSocket", include={"Socket::Constants"})
public class RubySocket
extends RubyBasicSocket {
    private static ObjectAllocator SOCKET_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubySocket(runtime, klass);
        }
    };
    private static final Pattern ALREADY_BOUND_PATTERN = Pattern.compile("[Aa]lready.*bound");
    private static final Pattern ADDR_NOT_AVAIL_PATTERN = Pattern.compile("assign.*address");
    private static final Pattern PERM_DENIED_PATTERN = Pattern.compile("[Pp]ermission.*denied");
    public static final int MSG_OOB = 1;
    public static final int MSG_PEEK = 2;
    public static final int MSG_DONTROUTE = 4;
    public static final int MSG_WAITALL = 256;
    protected AddressFamily soDomain;
    protected Sock soType;
    protected ProtocolFamily soProtocol;
    private static final String JRUBY_SERVER_SOCKET_ERROR = "use ServerSocket for servers (http://wiki.jruby.org/ServerSocket)";

    static void createSocket(Ruby runtime) {
        RubyClass rb_cSocket = runtime.defineClass("Socket", runtime.getClass("BasicSocket"), SOCKET_ALLOCATOR);
        RubyModule rb_mConstants = rb_cSocket.defineModuleUnder("Constants");
        runtime.loadConstantSet(rb_mConstants, Sock.class);
        runtime.loadConstantSet(rb_mConstants, SocketOption.class);
        runtime.loadConstantSet(rb_mConstants, SocketLevel.class);
        runtime.loadConstantSet(rb_mConstants, ProtocolFamily.class);
        runtime.loadConstantSet(rb_mConstants, AddressFamily.class);
        runtime.loadConstantSet(rb_mConstants, INAddr.class);
        runtime.loadConstantSet(rb_mConstants, IPProto.class);
        runtime.loadConstantSet(rb_mConstants, Shutdown.class);
        runtime.loadConstantSet(rb_mConstants, TCP.class);
        runtime.loadConstantSet(rb_mConstants, NameInfo.class);
        rb_mConstants.setConstant("SOMAXCONN", RubyFixnum.newFixnum(runtime, 128L));
        rb_mConstants.setConstant("MSG_OOB", runtime.newFixnum(1));
        rb_mConstants.setConstant("MSG_PEEK", runtime.newFixnum(2));
        rb_mConstants.setConstant("MSG_DONTROUTE", runtime.newFixnum(4));
        rb_mConstants.setConstant("MSG_WAITALL", runtime.newFixnum(256));
        rb_mConstants.setConstant("AI_PASSIVE", runtime.newFixnum(1));
        rb_mConstants.setConstant("IP_MULTICAST_TTL", runtime.newFixnum(10));
        rb_mConstants.setConstant("IP_MULTICAST_LOOP", runtime.newFixnum(11));
        rb_mConstants.setConstant("IP_ADD_MEMBERSHIP", runtime.newFixnum(12));
        rb_mConstants.setConstant("IP_MAX_MEMBERSHIPS", runtime.newFixnum(20));
        rb_mConstants.setConstant("IP_DEFAULT_MULTICAST_LOOP", runtime.newFixnum(1));
        rb_mConstants.setConstant("IP_DEFAULT_MULTICAST_TTL", runtime.newFixnum(1));
        rb_cSocket.includeModule(rb_mConstants);
        rb_cSocket.defineAnnotatedMethods(RubySocket.class);
    }

    public RubySocket(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject for_fd(ThreadContext context, IRubyObject socketClass, IRubyObject fd) {
        Ruby runtime = context.runtime;
        if (fd instanceof RubyFixnum) {
            int intFD = (int)((RubyFixnum)fd).getLongValue();
            ChannelDescriptor descriptor = ChannelDescriptor.getDescriptorByFileno(intFD);
            if (descriptor == null) {
                throw runtime.newErrnoEBADFError();
            }
            RubySocket socket2 = (RubySocket)((RubyClass)socketClass).allocate();
            socket2.initFieldsFromDescriptor(runtime, descriptor);
            socket2.initSocket(runtime, descriptor);
            return socket2;
        }
        throw runtime.newTypeError(fd, context.runtime.getFixnum());
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_8, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject domain, IRubyObject type2, IRubyObject protocol2) {
        Ruby runtime = context.runtime;
        this.initFieldsFromArgs(runtime, domain, type2, protocol2);
        ChannelDescriptor descriptor = this.initChannel(runtime);
        this.initSocket(runtime, descriptor);
        return this;
    }

    @JRubyMethod(name={"initialize"}, compat=CompatVersion.RUBY1_9, visibility=Visibility.PRIVATE)
    public IRubyObject initialize19(ThreadContext context, IRubyObject domain, IRubyObject type2) {
        Ruby runtime = context.runtime;
        this.initFieldsFromArgs(runtime, domain, type2);
        ChannelDescriptor descriptor = this.initChannel(runtime);
        this.initSocket(runtime, descriptor);
        return this;
    }

    @JRubyMethod(name={"initialize"}, compat=CompatVersion.RUBY1_9, visibility=Visibility.PRIVATE)
    public IRubyObject initialize19(ThreadContext context, IRubyObject domain, IRubyObject type2, IRubyObject protocol2) {
        Ruby runtime = context.runtime;
        this.initFieldsFromArgs(runtime, domain, type2, protocol2);
        ChannelDescriptor descriptor = this.initChannel(runtime);
        this.initSocket(runtime, descriptor);
        return this;
    }

    @JRubyMethod
    public IRubyObject connect_nonblock(ThreadContext context, IRubyObject arg2) {
        SocketAddress addr2 = this.addressForChannel(context, arg2);
        this.doConnectNonblock(context, this.getChannel(), addr2);
        return RubyFixnum.zero(context.runtime);
    }

    @JRubyMethod
    public IRubyObject connect(ThreadContext context, IRubyObject arg2) {
        SocketAddress addr2 = this.addressForChannel(context, arg2);
        this.doConnect(context, this.getChannel(), addr2);
        return RubyFixnum.zero(context.runtime);
    }

    @JRubyMethod
    public IRubyObject bind(ThreadContext context, IRubyObject arg2) {
        InetSocketAddress iaddr = Sockaddr.addressFromArg(context, arg2);
        this.doBind(context, this.getChannel(), iaddr);
        return RubyFixnum.zero(context.runtime);
    }

    @JRubyMethod
    public IRubyObject recvfrom(ThreadContext context, IRubyObject length2) {
        return super.recv(context, length2);
    }

    @JRubyMethod
    public IRubyObject recvfrom(ThreadContext context, IRubyObject length2, IRubyObject flags) {
        return super.recv(context, length2, flags);
    }

    @JRubyMethod
    public IRubyObject recvfrom_nonblock(ThreadContext context, IRubyObject length2) {
        return super.recv_nonblock(context, length2);
    }

    @JRubyMethod
    public IRubyObject recvfrom_nonblock(ThreadContext context, IRubyObject length2, IRubyObject flags) {
        return super.recv_nonblock(context, length2, flags);
    }

    @JRubyMethod(notImplemented=true)
    public IRubyObject listen(ThreadContext context, IRubyObject backlog) {
        throw SocketUtils.sockerr(context.runtime, JRUBY_SERVER_SOCKET_ERROR);
    }

    @JRubyMethod(notImplemented=true)
    public IRubyObject accept(ThreadContext context) {
        throw SocketUtils.sockerr(context.runtime, JRUBY_SERVER_SOCKET_ERROR);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject gethostname(ThreadContext context, IRubyObject recv2) {
        return SocketUtils.gethostname(context);
    }

    @JRubyMethod(required=1, rest=true, meta=true)
    public static IRubyObject gethostbyaddr(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return SocketUtils.gethostbyaddr(context, args2);
    }

    @JRubyMethod(required=1, optional=1, meta=true)
    public static IRubyObject getservbyname(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return SocketUtils.getservbyname(context, args2);
    }

    @JRubyMethod(name={"pack_sockaddr_in", "sockaddr_in"}, meta=true)
    public static IRubyObject pack_sockaddr_in(ThreadContext context, IRubyObject recv2, IRubyObject port, IRubyObject host) {
        return SocketUtils.pack_sockaddr_in(context, port, host);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject unpack_sockaddr_in(ThreadContext context, IRubyObject recv2, IRubyObject addr2) {
        return Sockaddr.unpack_sockaddr_in(context, addr2);
    }

    @JRubyMethod(name={"pack_sockaddr_un", "sockaddr_un"}, meta=true)
    public static IRubyObject pack_sockaddr_un(ThreadContext context, IRubyObject recv2, IRubyObject filename2) {
        return SocketUtils.pack_sockaddr_un(context, filename2);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject gethostbyname(ThreadContext context, IRubyObject recv2, IRubyObject hostname) {
        return SocketUtils.gethostbyname(context, hostname);
    }

    @JRubyMethod(required=2, optional=4, meta=true)
    public static IRubyObject getaddrinfo(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return SocketUtils.getaddrinfo(context, args2);
    }

    @JRubyMethod(required=1, optional=1, meta=true)
    public static IRubyObject getnameinfo(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        return SocketUtils.getnameinfo(context, args2);
    }

    @JRubyMethod(meta=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject ip_address_list(ThreadContext context, IRubyObject self2) {
        return SocketUtils.ip_address_list(context);
    }

    @Override
    protected Sock getDefaultSocketType() {
        return this.soType;
    }

    private void initFieldsFromDescriptor(Ruby runtime, ChannelDescriptor descriptor) {
        Channel mainChannel = descriptor.getChannel();
        if (mainChannel instanceof SocketChannel) {
            this.soDomain = AddressFamily.AF_INET;
            this.soType = Sock.SOCK_STREAM;
            this.soProtocol = ProtocolFamily.PF_INET;
        } else if (mainChannel instanceof UnixSocketChannel) {
            this.soDomain = AddressFamily.AF_UNIX;
            this.soType = Sock.SOCK_STREAM;
            this.soProtocol = ProtocolFamily.PF_UNIX;
        } else if (mainChannel instanceof DatagramChannel) {
            this.soDomain = AddressFamily.AF_INET;
            this.soType = Sock.SOCK_DGRAM;
            this.soProtocol = ProtocolFamily.PF_INET;
        } else {
            throw runtime.newErrnoENOTSOCKError("can't Socket.new/for_fd against a non-socket");
        }
    }

    private void initFieldsFromArgs(Ruby runtime, IRubyObject domain, IRubyObject type2, IRubyObject protocol2) {
        this.initDomain(runtime, domain);
        this.initType(runtime, type2);
        this.initProtocol(runtime, protocol2);
    }

    private void initFieldsFromArgs(Ruby runtime, IRubyObject domain, IRubyObject type2) {
        this.initDomain(runtime, domain);
        this.initType(runtime, type2);
    }

    protected void initFromServer(Ruby runtime, RubyServerSocket serverSocket, SocketChannel socketChannel) {
        this.soDomain = serverSocket.soDomain;
        this.soType = serverSocket.soType;
        this.soProtocol = serverSocket.soProtocol;
        this.initSocket(runtime, RubySocket.newChannelDescriptor(runtime, socketChannel));
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ChannelDescriptor initChannel(Ruby runtime) {
        try {
            void var2_5;
            if (this.soType == Sock.SOCK_STREAM) {
                if (this.soProtocol == ProtocolFamily.PF_UNIX || this.soProtocol == ProtocolFamily.PF_LOCAL) {
                    UnixSocketChannel unixSocketChannel = UnixSocketChannel.open();
                    return RubySocket.newChannelDescriptor(runtime, (Channel)var2_5);
                } else {
                    if (this.soProtocol != ProtocolFamily.PF_INET && this.soProtocol != ProtocolFamily.PF_INET6 && this.soProtocol != ProtocolFamily.PF_UNSPEC) throw runtime.newArgumentError("unsupported protocol family `" + this.soProtocol + "'");
                    SocketChannel socketChannel = SocketChannel.open();
                }
                return RubySocket.newChannelDescriptor(runtime, (Channel)var2_5);
            } else {
                if (this.soType != Sock.SOCK_DGRAM) throw runtime.newArgumentError("unsupported socket type `" + this.soType + "'");
                DatagramChannel datagramChannel = DatagramChannel.open();
            }
            return RubySocket.newChannelDescriptor(runtime, (Channel)var2_5);
        }
        catch (IOException e) {
            throw SocketUtils.sockerr(runtime, "initialize: " + e.toString());
        }
    }

    protected static ChannelDescriptor newChannelDescriptor(Ruby runtime, Channel channel) {
        ModeFlags modeFlags = RubySocket.newModeFlags(runtime, ModeFlags.RDWR);
        return new ChannelDescriptor(channel, modeFlags);
    }

    private void initProtocol(Ruby runtime, IRubyObject protocol2) {
        ProtocolFamily protocolFamily = SocketUtils.protocolFamilyFromArg(protocol2);
        if (protocolFamily == null) {
            return;
        }
        this.soProtocol = protocolFamily;
    }

    private void initType(Ruby runtime, IRubyObject type2) {
        Sock sockType = SocketUtils.sockFromArg(type2);
        if (sockType == null) {
            throw SocketUtils.sockerr(runtime, "unknown socket type " + type2);
        }
        this.soType = sockType;
    }

    private void initDomain(Ruby runtime, IRubyObject domain) {
        AddressFamily family2 = SocketUtils.addressFamilyFromArg(domain);
        if (family2 == null) {
            throw SocketUtils.sockerr(runtime, "unknown socket domain " + domain);
        }
        this.soDomain = family2;
        this.soProtocol = ProtocolFamily.valueOf("PF" + this.soDomain.name().substring(2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doConnectNonblock(ThreadContext context, Channel channel, SocketAddress addr2) {
        if (!(channel instanceof SelectableChannel)) {
            throw this.getRuntime().newErrnoENOPROTOOPTError();
        }
        SelectableChannel selectable = (SelectableChannel)channel;
        Object object = selectable.blockingLock();
        synchronized (object) {
            boolean oldBlocking = selectable.isBlocking();
            try {
                selectable.configureBlocking(false);
                try {
                    this.doConnect(context, channel, addr2);
                }
                finally {
                    selectable.configureBlocking(oldBlocking);
                }
            }
            catch (ClosedChannelException e) {
                throw context.runtime.newErrnoECONNREFUSEDError();
            }
            catch (IOException e) {
                throw SocketUtils.sockerr(context.runtime, "connect(2): name or service not known");
            }
        }
    }

    protected void doConnect(ThreadContext context, Channel channel, SocketAddress addr2) {
        block13: {
            Ruby runtime = context.runtime;
            try {
                if (channel instanceof SocketChannel) {
                    SocketChannel socket2 = (SocketChannel)channel;
                    boolean result2 = socket2.isConnectionPending() ? socket2.finishConnect() : socket2.connect(addr2);
                    if (!result2) {
                        if (runtime.is1_9()) {
                            throw runtime.newErrnoEINPROGRESSWritableError();
                        }
                        throw runtime.newErrnoEINPROGRESSError();
                    }
                    break block13;
                }
                if (channel instanceof UnixSocketChannel) {
                    ((UnixSocketChannel)channel).connect((UnixSocketAddress)addr2);
                    break block13;
                }
                if (channel instanceof DatagramChannel) {
                    ((DatagramChannel)channel).connect(addr2);
                    break block13;
                }
                throw runtime.newErrnoENOPROTOOPTError();
            }
            catch (AlreadyConnectedException e) {
                throw runtime.newErrnoEISCONNError();
            }
            catch (ConnectionPendingException e) {
                if (runtime.is1_9()) {
                    throw runtime.newErrnoEINPROGRESSWritableError();
                }
                throw runtime.newErrnoEINPROGRESSError();
            }
            catch (UnknownHostException e) {
                throw SocketUtils.sockerr(runtime, "connect(2): unknown host");
            }
            catch (SocketException e) {
                this.handleSocketException(runtime, "connect", e);
            }
            catch (IOException e) {
                throw SocketUtils.sockerr(runtime, "connect(2): name or service not known");
            }
            catch (IllegalArgumentException iae) {
                throw SocketUtils.sockerr(runtime, iae.getMessage());
            }
        }
    }

    protected void doBind(ThreadContext context, Channel channel, InetSocketAddress iaddr) {
        block7: {
            Ruby runtime = context.runtime;
            try {
                if (channel instanceof SocketChannel) {
                    Socket socket2 = ((SocketChannel)channel).socket();
                    socket2.bind(iaddr);
                    break block7;
                }
                if (channel instanceof UnixSocketChannel) break block7;
                if (channel instanceof DatagramChannel) {
                    DatagramSocket socket3 = ((DatagramChannel)channel).socket();
                    socket3.bind(iaddr);
                    break block7;
                }
                throw runtime.newErrnoENOPROTOOPTError();
            }
            catch (UnknownHostException e) {
                throw SocketUtils.sockerr(runtime, "bind(2): unknown host");
            }
            catch (SocketException e) {
                this.handleSocketException(runtime, "bind", e);
            }
            catch (IOException e) {
                throw SocketUtils.sockerr(runtime, "bind(2): name or service not known");
            }
            catch (IllegalArgumentException iae) {
                throw SocketUtils.sockerr(runtime, iae.getMessage());
            }
        }
    }

    protected void handleSocketException(Ruby runtime, String caller2, SocketException e) {
        String msg = RubySocket.formatMessage(e, "bind");
        if (ALREADY_BOUND_PATTERN.matcher(msg).find()) {
            throw runtime.newErrnoEINVALError(msg);
        }
        if (ADDR_NOT_AVAIL_PATTERN.matcher(msg).find()) {
            throw runtime.newErrnoEADDRNOTAVAILError(msg);
        }
        if (PERM_DENIED_PATTERN.matcher(msg).find()) {
            throw runtime.newErrnoEACCESError(msg);
        }
        throw runtime.newErrnoEADDRINUSEError(msg);
    }

    private static String formatMessage(Throwable e, String defaultMsg) {
        String msg = e.getMessage();
        msg = msg == null ? defaultMsg : defaultMsg + " - " + msg;
        return msg;
    }

    private SocketAddress addressForChannel(ThreadContext context, IRubyObject arg2) {
        if (arg2 instanceof Addrinfo) {
            return Sockaddr.addressFromArg(context, arg2);
        }
        switch (this.soProtocol) {
            case PF_UNIX: 
            case PF_LOCAL: {
                return Sockaddr.addressFromSockaddr_un(context, arg2);
            }
            case PF_INET: 
            case PF_INET6: 
            case PF_UNSPEC: {
                return Sockaddr.addressFromSockaddr_in(context, arg2);
            }
        }
        throw context.runtime.newArgumentError("unsupported protocol family `" + this.soProtocol + "'");
    }

    @Deprecated
    public static RuntimeException sockerr(Ruby runtime, String msg) {
        return new RaiseException(runtime, runtime.getClass("SocketError"), msg, true);
    }
}

