/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import com.sun.mail.imap.SortTerm;
import javax.mail.search.SearchTerm;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.mail.ContentTypeResolver;
import org.apache.camel.component.mail.JavaMailSender;
import org.apache.camel.component.mail.MailBinding;
import org.apache.camel.component.mail.MailBoxPostProcessAction;
import org.apache.camel.component.mail.MailComponent;
import org.apache.camel.component.mail.MailConfiguration;
import org.apache.camel.component.mail.MailConsumer;
import org.apache.camel.component.mail.MailHeaderFilterStrategy;
import org.apache.camel.component.mail.MailMessage;
import org.apache.camel.component.mail.MailProducer;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.ScheduledPollEndpoint;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;

@UriEndpoint(scheme="imap,imaps,pop3,pop3s,smtp,smtps", title="IMAP,IMAPS,POP3,POP3S,SMTP,SMTPS", syntax="imap:host:port", consumerClass=MailConsumer.class, label="mail")
public class MailEndpoint
extends ScheduledPollEndpoint {
    @UriParam
    private MailConfiguration configuration;
    @UriParam
    private MailBinding binding;
    @UriParam
    private HeaderFilterStrategy headerFilterStrategy = new MailHeaderFilterStrategy();
    @UriParam
    private ContentTypeResolver contentTypeResolver;
    @UriParam
    private int maxMessagesPerPoll;
    @UriParam
    private SearchTerm searchTerm;
    @UriParam
    private SortTerm[] sortTerm;
    @UriParam
    private MailBoxPostProcessAction postProcessAction;

    public MailEndpoint() {
    }

    public MailEndpoint(String uri, MailComponent component, MailConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    @Deprecated
    public MailEndpoint(String endpointUri, MailConfiguration configuration) {
        super(endpointUri);
        this.configuration = configuration;
    }

    public MailEndpoint(String endpointUri) {
        this(endpointUri, new MailConfiguration());
    }

    public Producer createProducer() throws Exception {
        JavaMailSender sender = this.configuration.getJavaMailSender();
        if (sender == null) {
            sender = this.configuration.createJavaMailSender();
        }
        return this.createProducer(sender);
    }

    public Producer createProducer(JavaMailSender sender) throws Exception {
        return new MailProducer(this, sender);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        if (this.configuration.getProtocol().startsWith("smtp")) {
            throw new IllegalArgumentException("Protocol " + this.configuration.getProtocol() + " cannot be used for a MailConsumer. Please use another protocol such as pop3 or imap.");
        }
        JavaMailSender sender = this.configuration.createJavaMailSender();
        return this.createConsumer(processor, sender);
    }

    public Consumer createConsumer(Processor processor, JavaMailSender sender) throws Exception {
        MailConsumer answer = new MailConsumer(this, processor, sender);
        answer.setHandleFailedMessage(this.configuration.isHandleFailedMessage());
        answer.setSkipFailedMessage(this.configuration.isSkipFailedMessage());
        answer.setDelay(60000L);
        answer.setMaxMessagesPerPoll(this.getMaxMessagesPerPoll());
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public boolean isSingleton() {
        return false;
    }

    public Exchange createExchange(ExchangePattern pattern) {
        return this.createExchange(pattern, null);
    }

    public Exchange createExchange(javax.mail.Message message) {
        return this.createExchange(this.getExchangePattern(), message);
    }

    private Exchange createExchange(ExchangePattern pattern, javax.mail.Message message) {
        DefaultExchange exchange = new DefaultExchange((Endpoint)this, pattern);
        exchange.setProperty("CamelBinding", (Object)this.getBinding());
        exchange.setIn((Message)new MailMessage(message, this.getConfiguration().isMapMailMessage()));
        return exchange;
    }

    public MailBinding getBinding() {
        if (this.binding == null) {
            this.binding = new MailBinding(this.headerFilterStrategy, this.contentTypeResolver);
        }
        return this.binding;
    }

    public void setBinding(MailBinding binding) {
        this.binding = binding;
    }

    public MailConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(MailConfiguration configuration) {
        this.configuration = configuration;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return this.headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }

    public ContentTypeResolver getContentTypeResolver() {
        return this.contentTypeResolver;
    }

    public void setContentTypeResolver(ContentTypeResolver contentTypeResolver) {
        this.contentTypeResolver = contentTypeResolver;
    }

    public int getMaxMessagesPerPoll() {
        return this.maxMessagesPerPoll;
    }

    public void setMaxMessagesPerPoll(int maxMessagesPerPoll) {
        this.maxMessagesPerPoll = maxMessagesPerPoll;
    }

    public SearchTerm getSearchTerm() {
        return this.searchTerm;
    }

    public void setSearchTerm(SearchTerm searchTerm) {
        this.searchTerm = searchTerm;
    }

    public SortTerm[] getSortTerm() {
        return this.sortTerm == null ? null : (SortTerm[])this.sortTerm.clone();
    }

    public void setSortTerm(SortTerm[] sortTerm) {
        this.sortTerm = sortTerm == null ? null : (SortTerm[])sortTerm.clone();
    }

    public MailBoxPostProcessAction getPostProcessAction() {
        return this.postProcessAction;
    }

    public void setPostProcessAction(MailBoxPostProcessAction postProcessAction) {
        this.postProcessAction = postProcessAction;
    }
}

