/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import java.util.ArrayList;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.support.ExpressionAdapter;

public class SplitAttachmentsExpression
extends ExpressionAdapter {
    public Object evaluate(Exchange exchange) {
        if (exchange.getIn().getAttachments().isEmpty()) {
            return null;
        }
        ArrayList<Message> answer = new ArrayList<Message>();
        for (Map.Entry entry : exchange.getIn().getAttachments().entrySet()) {
            Message copy = exchange.getIn().copy();
            String key = (String)entry.getKey();
            Map attachments = copy.getAttachments();
            attachments.clear();
            attachments.put(key, entry.getValue());
            copy.setHeader("CamelSplitAttachmentId", (Object)key);
            answer.add(copy);
        }
        return answer;
    }
}

