/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.util.Iterator;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.LocalVariableReference;
import net.sf.saxon.expr.PairIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.functions.Current;
import net.sf.saxon.om.Item;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.pattern.PatternSponsor;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.type.ItemType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PatternWithPredicate
extends Pattern {
    private Pattern basePattern;
    private Expression predicate;

    public PatternWithPredicate(Pattern basePattern, Expression predicate) {
        this.basePattern = basePattern;
        this.predicate = predicate;
    }

    @Override
    public void bindCurrent(Binding binding) {
        if (this.predicate instanceof Current) {
            this.predicate = new LocalVariableReference(binding);
        } else if (ExpressionTool.callsFunction(this.predicate, Current.FN_CURRENT)) {
            PatternWithPredicate.replaceCurrent(this.predicate, binding);
        }
        this.basePattern.bindCurrent(binding);
    }

    @Override
    public void promote(PromotionOffer offer, Expression parent) throws XPathException {
        Binding[] savedBindingList = offer.bindingList;
        this.basePattern.promote(offer, parent);
        this.predicate = this.predicate.promote(offer, parent);
        offer.bindingList = savedBindingList;
    }

    @Override
    public int allocateSlots(SlotManager slotManager, int nextFree) {
        int n = ExpressionTool.allocateSlots(this.predicate, nextFree, slotManager);
        return this.basePattern.allocateSlots(slotManager, n);
    }

    @Override
    public int getNodeKind() {
        return this.basePattern.getNodeKind();
    }

    @Override
    public int getFingerprint() {
        return this.basePattern.getFingerprint();
    }

    @Override
    public int getDependencies() {
        return this.predicate.getDependencies() | this.basePattern.getDependencies();
    }

    @Override
    public boolean matches(Item item, XPathContext context) throws XPathException {
        if (!this.basePattern.matches(item, context)) {
            return false;
        }
        XPathContextMinor c2 = context.newMinorContext();
        SingletonIterator si = (SingletonIterator)SingletonIterator.makeIterator(item);
        si.next();
        c2.setCurrentIterator(si);
        try {
            return this.predicate.effectiveBooleanValue(c2);
        }
        catch (XPathException e) {
            if ("XTDE0640".equals(e.getErrorCodeLocalPart())) {
                throw e;
            }
            XPathException err = new XPathException("An error occurred matching pattern {" + this.toString() + "}: ", e);
            err.setXPathContext(c2);
            err.setErrorCodeQName(e.getErrorCodeQName());
            err.setLocator(this);
            c2.getController().recoverableError(err);
            return false;
        }
    }

    @Override
    public ItemType getItemType() {
        return this.basePattern.getItemType();
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return new PairIterator<Expression>(new PatternSponsor(this.basePattern), this.predicate);
    }

    @Override
    public Pattern analyze(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        ExpressionVisitor.ContextItemType cit = new ExpressionVisitor.ContextItemType(this.getItemType(), false);
        this.predicate = visitor.typeCheck(this.predicate, cit);
        this.basePattern = this.basePattern.analyze(visitor, contextItemType);
        return this;
    }

    @Override
    public double getDefaultPriority() {
        return 0.5;
    }
}

