/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.regex;

import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.regex.BMPString;
import net.sf.saxon.regex.REMatcher;
import net.sf.saxon.regex.UnicodeString;
import net.sf.saxon.value.StringValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ATokenIterator
implements SequenceIterator<StringValue> {
    private UnicodeString input;
    private REMatcher matcher;
    private UnicodeString current;
    private int position = 0;
    private int prevEnd = 0;

    public ATokenIterator(UnicodeString input, REMatcher matcher) {
        this.input = input;
        this.matcher = matcher;
        this.prevEnd = 0;
    }

    @Override
    public StringValue next() {
        if (this.prevEnd < 0) {
            this.current = null;
            this.position = -1;
            return null;
        }
        if (this.matcher.match(this.input, this.prevEnd)) {
            int start = this.matcher.getParenStart(0);
            this.current = this.input.substring(this.prevEnd, start);
            this.prevEnd = this.matcher.getParenEnd(0);
        } else {
            this.current = this.input.substring(this.prevEnd, this.input.length());
            this.prevEnd = -1;
        }
        ++this.position;
        return this.currentStringValue();
    }

    private StringValue currentStringValue() {
        if (this.current instanceof BMPString) {
            return StringValue.makeStringValue(((BMPString)this.current).getCharSequence());
        }
        return StringValue.makeStringValue(this.current.toString());
    }

    @Override
    public StringValue current() {
        return this.current == null ? null : this.currentStringValue();
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public void close() {
    }

    public ATokenIterator getAnother() {
        return new ATokenIterator(this.input, new REMatcher(this.matcher.getProgram()));
    }

    @Override
    public int getProperties() {
        return 0;
    }
}

