/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.s9api;

import java.text.Collator;
import java.text.RuleBasedCollator;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.URIResolver;
import net.sf.saxon.Configuration;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.expr.CollationMap;
import net.sf.saxon.expr.sort.RuleBasedSubstringMatcher;
import net.sf.saxon.expr.sort.SimpleCollation;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.trace.XSLTTraceCodeInjector;
import net.sf.saxon.trans.CompilerInfo;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.value.DecimalValue;

public class XsltCompiler {
    private Processor processor;
    private Configuration config;
    private CompilerInfo compilerInfo;
    private Map<QName, XdmValue> variableList = new HashMap<QName, XdmValue>();

    protected XsltCompiler(Processor processor) {
        this.processor = processor;
        this.config = processor.getUnderlyingConfiguration();
        this.compilerInfo = new CompilerInfo(this.config.getDefaultXsltCompilerInfo());
        this.compilerInfo.setCollationMap(new CollationMap(this.config.getCollationMap()));
    }

    public Processor getProcessor() {
        return this.processor;
    }

    public void setURIResolver(URIResolver resolver) {
        this.compilerInfo.setURIResolver(resolver);
    }

    public void setParameter(QName name, XdmValue value) {
        this.variableList.put(name, value);
        this.compilerInfo.setParameter(name.getStructuredQName(), value.getUnderlyingValue());
    }

    public URIResolver getURIResolver() {
        return this.compilerInfo.getURIResolver();
    }

    public void setErrorListener(ErrorListener listener) {
        this.compilerInfo.setErrorListener(listener);
    }

    public ErrorListener getErrorListener() {
        return this.compilerInfo.getErrorListener();
    }

    public void setSchemaAware(boolean schemaAware) {
        this.compilerInfo.setSchemaAware(schemaAware);
    }

    public boolean isSchemaAware() {
        return this.compilerInfo.isSchemaAware();
    }

    public void declareCollation(String uri, Collator collation) {
        if (uri.equals("http://www.w3.org/2005/xpath-functions/collation/codepoint")) {
            throw new IllegalArgumentException("Cannot declare the Unicode codepoint collation URI");
        }
        SimpleCollation saxonCollation = collation instanceof RuleBasedCollator ? new RuleBasedSubstringMatcher((RuleBasedCollator)collation) : new SimpleCollation(collation);
        this.compilerInfo.getCollationMap().setNamedCollation(uri, saxonCollation);
    }

    public void declareDefaultCollation(String uri) {
        if (this.compilerInfo.getCollationMap().getNamedCollation(uri) == null) {
            throw new IllegalStateException("Unknown collation " + uri);
        }
        this.compilerInfo.getCollationMap().setDefaultCollationName(uri);
    }

    public void setXsltLanguageVersion(String version) {
        DecimalValue v;
        try {
            v = (DecimalValue)DecimalValue.makeDecimalValue(version, true).asAtomic();
        }
        catch (ValidationException ve) {
            throw new IllegalArgumentException(ve);
        }
        if (DecimalValue.TWO_POINT_ONE.equals(v)) {
            v = DecimalValue.THREE;
        }
        if (!DecimalValue.TWO.equals(v) && !DecimalValue.THREE.equals(v)) {
            throw new IllegalArgumentException("LanguageVersion " + v);
        }
        this.compilerInfo.setXsltVersion(v);
    }

    public String getXsltLanguageVersion() {
        return this.compilerInfo.getXsltVersion().toString();
    }

    public void setCompileWithTracing(boolean option) {
        if (option) {
            this.compilerInfo.setCodeInjector(new XSLTTraceCodeInjector());
        } else {
            this.compilerInfo.setCodeInjector(null);
        }
    }

    public boolean isCompileWithTracing() {
        return this.compilerInfo.isCompileWithTracing();
    }

    public XsltExecutable compile(Source source) throws SaxonApiException {
        try {
            PreparedStylesheet pss = PreparedStylesheet.compile(source, this.config, this.compilerInfo);
            return new XsltExecutable(this.processor, pss);
        }
        catch (TransformerConfigurationException e) {
            throw new SaxonApiException(e);
        }
    }

    public CompilerInfo getUnderlyingCompilerInfo() {
        return this.compilerInfo;
    }
}

