/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jmx;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.component.jmx.JMXEndpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.util.EndpointHelper;

public class JMXComponent
extends UriEndpointComponent {
    public JMXComponent() {
        super(JMXEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        JMXEndpoint endpoint = new JMXEndpoint(uri, this);
        EndpointHelper.setReferenceProperties((CamelContext)this.getCamelContext(), (Object)((Object)endpoint), parameters);
        EndpointHelper.setProperties((CamelContext)this.getCamelContext(), (Object)((Object)endpoint), parameters);
        endpoint.setServerURL(remaining);
        if (!parameters.isEmpty()) {
            Hashtable<String, String> objectProperties = new Hashtable<String, String>();
            Iterator<Map.Entry<String, Object>> it = parameters.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Object> entry = it.next();
                if (!entry.getKey().startsWith("key.")) continue;
                objectProperties.put(entry.getKey().substring("key.".length()), entry.getValue().toString());
                it.remove();
            }
            endpoint.setObjectProperties(objectProperties);
        }
        if (endpoint.getObjectDomain() == null) {
            throw new IllegalArgumentException("Must specify domain");
        }
        if (endpoint.getObjectName() == null && endpoint.getObjectProperties() == null) {
            throw new IllegalArgumentException("Must specify object name or object properties");
        }
        return endpoint;
    }
}

