/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.timer;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.Endpoint;
import org.apache.camel.component.timer.TimerConsumer;
import org.apache.camel.component.timer.TimerEndpoint;
import org.apache.camel.impl.UriEndpointComponent;

public class TimerComponent
extends UriEndpointComponent {
    private final Map<String, Timer> timers = new HashMap<String, Timer>();
    private final Map<String, AtomicInteger> refCounts = new HashMap<String, AtomicInteger>();

    public TimerComponent() {
        super(TimerEndpoint.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timer getTimer(TimerConsumer consumer) {
        Timer answer;
        String key = consumer.getEndpoint().getTimerName();
        if (!consumer.getEndpoint().isDaemon()) {
            key = "nonDaemon:" + key;
        }
        Map<String, Timer> map = this.timers;
        synchronized (map) {
            answer = this.timers.get(key);
            if (answer == null) {
                String name = consumer.getEndpoint().getCamelContext().getExecutorServiceManager().resolveThreadName("timer://" + consumer.getEndpoint().getTimerName());
                answer = new Timer(name, consumer.getEndpoint().isDaemon());
                this.timers.put(key, answer);
                this.refCounts.put(key, new AtomicInteger(1));
            } else {
                AtomicInteger counter = this.refCounts.get(key);
                if (counter != null) {
                    counter.incrementAndGet();
                }
            }
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTimer(TimerConsumer consumer) {
        String key = consumer.getEndpoint().getTimerName();
        if (!consumer.getEndpoint().isDaemon()) {
            key = "nonDaemon:" + key;
        }
        Map<String, Timer> map = this.timers;
        synchronized (map) {
            AtomicInteger counter = this.refCounts.get(key);
            if (counter != null && counter.decrementAndGet() <= 0) {
                this.refCounts.remove(key);
                Timer timer = this.timers.remove(key);
                if (timer != null) {
                    timer.cancel();
                }
            }
        }
    }

    @Override
    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        TimerEndpoint answer = new TimerEndpoint(uri, this, remaining);
        String time = this.getAndRemoveParameter(parameters, "time", String.class);
        String pattern = this.getAndRemoveParameter(parameters, "pattern", String.class);
        if (time != null) {
            SimpleDateFormat sdf = pattern != null ? new SimpleDateFormat(pattern) : (time.contains("T") ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss") : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
            Date date = sdf.parse(time);
            answer.setTime(date);
        }
        this.setProperties(answer, parameters);
        return answer;
    }

    @Override
    protected void doStop() throws Exception {
        Collection<Timer> collection = this.timers.values();
        for (Timer timer : collection) {
            timer.cancel();
        }
        this.timers.clear();
        this.refCounts.clear();
    }
}

