/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.camel.CamelContext;
import org.apache.camel.model.dataformat.UniVocityAbstractDataFormat;
import org.apache.camel.model.dataformat.UniVocityHeader;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.Metadata;

@Metadata(label="dataformat,transformation", title="uniVocity Fixed Length")
@XmlRootElement(name="univocity-fixed")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class UniVocityFixedWidthDataFormat
extends UniVocityAbstractDataFormat {
    @XmlAttribute
    protected Boolean skipTrailingCharsUntilNewline;
    @XmlAttribute
    protected Boolean recordEndsOnNewline;
    @XmlAttribute
    @Metadata(defaultValue=" ")
    protected String padding;

    public UniVocityFixedWidthDataFormat() {
        super("univocity-fixed");
    }

    public Boolean getSkipTrailingCharsUntilNewline() {
        return this.skipTrailingCharsUntilNewline;
    }

    public void setSkipTrailingCharsUntilNewline(Boolean skipTrailingCharsUntilNewline) {
        this.skipTrailingCharsUntilNewline = skipTrailingCharsUntilNewline;
    }

    public Boolean getRecordEndsOnNewline() {
        return this.recordEndsOnNewline;
    }

    public void setRecordEndsOnNewline(Boolean recordEndsOnNewline) {
        this.recordEndsOnNewline = recordEndsOnNewline;
    }

    public String getPadding() {
        return this.padding;
    }

    public void setPadding(String padding) {
        this.padding = padding;
    }

    @Override
    protected void configureDataFormat(DataFormat dataFormat, CamelContext camelContext) {
        super.configureDataFormat(dataFormat, camelContext);
        if (this.headers != null) {
            int[] lengths = new int[this.headers.size()];
            for (int i = 0; i < lengths.length; ++i) {
                Integer length = ((UniVocityHeader)this.headers.get(i)).getLength();
                if (length == null) {
                    throw new IllegalArgumentException("The length of all headers must be defined.");
                }
                lengths[i] = length;
            }
            this.setProperty(camelContext, dataFormat, "fieldLengths", lengths);
        }
        if (this.skipTrailingCharsUntilNewline != null) {
            this.setProperty(camelContext, dataFormat, "skipTrailingCharsUntilNewline", this.skipTrailingCharsUntilNewline);
        }
        if (this.recordEndsOnNewline != null) {
            this.setProperty(camelContext, dataFormat, "recordEndsOnNewline", this.recordEndsOnNewline);
        }
        if (this.padding != null) {
            this.setProperty(camelContext, dataFormat, "padding", UniVocityFixedWidthDataFormat.singleCharOf("padding", this.padding));
        }
    }
}

