/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.Traceable;
import org.apache.camel.processor.DelegateAsyncProcessor;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatchProcessor
extends DelegateAsyncProcessor
implements Traceable {
    private static final Logger LOG = LoggerFactory.getLogger(CatchProcessor.class);
    private final List<Class<? extends Throwable>> exceptions;
    private final Predicate onWhen;
    private final Predicate handled;

    public CatchProcessor(List<Class<? extends Throwable>> exceptions, Processor processor, Predicate onWhen, Predicate handled) {
        super(processor);
        this.exceptions = exceptions;
        this.onWhen = onWhen;
        this.handled = handled;
    }

    @Override
    public String toString() {
        return "Catch[" + this.exceptions + " -> " + this.getProcessor() + "]";
    }

    @Override
    public String getTraceLabel() {
        return "catch";
    }

    @Override
    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        Exception e = exchange.getException();
        Throwable caught = this.catches(exchange, e);
        if (exchange.getProperty("CamelExceptionHandled") != null || caught == null) {
            callback.done(true);
            return true;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("This CatchProcessor catches the exception: {} caused by: {}", (Object)caught.getClass().getName(), (Object)e.getMessage());
        }
        if (exchange.getProperty("CamelFailureEndpoint") == null) {
            exchange.setProperty("CamelFailureEndpoint", exchange.getProperty("CamelToEndpoint"));
        }
        exchange.setProperty("CamelExceptionHandled", true);
        exchange.setProperty("CamelExceptionCaught", e);
        exchange.setException(null);
        exchange.removeProperty("CamelRedeliveryExhausted");
        final boolean handled = this.handles(exchange);
        if (LOG.isDebugEnabled()) {
            LOG.debug("The exception is handled: {} for the exception: {} caused by: {}", new Object[]{handled, e.getClass().getName(), e.getMessage()});
        }
        boolean sync = this.processor.process(exchange, new AsyncCallback(){

            @Override
            public void done(boolean doneSync) {
                if (!handled && exchange.getException() == null) {
                    exchange.setException(exchange.getProperty("CamelExceptionCaught", Exception.class));
                }
                exchange.removeProperty("CamelRedeliveryExhausted");
                if (!doneSync) {
                    ExchangeHelper.prepareOutToIn(exchange);
                }
                callback.done(doneSync);
            }
        });
        return sync;
    }

    protected Throwable catches(Exchange exchange, Throwable exception) {
        for (Throwable e : ObjectHelper.createExceptionIterable(exception)) {
            for (Class<? extends Throwable> type : this.exceptions) {
                if (!type.isInstance(e) || !this.matchesWhen(exchange)) continue;
                return e;
            }
        }
        return null;
    }

    protected boolean handles(Exchange exchange) {
        if (this.handled == null) {
            return true;
        }
        return this.handled.matches(exchange);
    }

    public List<Class<? extends Throwable>> getExceptions() {
        return this.exceptions;
    }

    protected boolean matchesWhen(Exchange exchange) {
        if (this.onWhen == null) {
            return true;
        }
        return this.onWhen.matches(exchange);
    }
}

