/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.datatype;

import ca.uhn.hl7v2.model.AbstractComposite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v24.datatype.CE;
import ca.uhn.hl7v2.model.v24.datatype.DR;
import ca.uhn.hl7v2.model.v24.datatype.FN;
import ca.uhn.hl7v2.model.v24.datatype.HD;
import ca.uhn.hl7v2.model.v24.datatype.ID;
import ca.uhn.hl7v2.model.v24.datatype.IS;
import ca.uhn.hl7v2.model.v24.datatype.ST;
import ca.uhn.hl7v2.model.v24.datatype.TS;

public class PPN
extends AbstractComposite {
    private Type[] data;

    public PPN(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[19];
        this.data[0] = new ST(this.getMessage());
        this.data[1] = new FN(this.getMessage());
        this.data[2] = new ST(this.getMessage());
        this.data[3] = new ST(this.getMessage());
        this.data[4] = new ST(this.getMessage());
        this.data[5] = new ST(this.getMessage());
        this.data[6] = new IS(this.getMessage(), 0);
        this.data[7] = new IS(this.getMessage(), 0);
        this.data[8] = new HD(this.getMessage());
        this.data[9] = new ID(this.getMessage(), 0);
        this.data[10] = new ST(this.getMessage());
        this.data[11] = new ID(this.getMessage(), 0);
        this.data[12] = new IS(this.getMessage(), 0);
        this.data[13] = new HD(this.getMessage());
        this.data[14] = new TS(this.getMessage());
        this.data[15] = new ID(this.getMessage(), 0);
        this.data[16] = new CE(this.getMessage());
        this.data[17] = new DR(this.getMessage());
        this.data[18] = new ID(this.getMessage(), 0);
    }

    public Type[] getComponents() {
        return this.data;
    }

    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + ((Object)((Object)this)).getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public ST getIDNumber() {
        return (ST)this.getTyped(0, ST.class);
    }

    public ST getPpn1_IDNumber() {
        return (ST)this.getTyped(0, ST.class);
    }

    public FN getFamilyName() {
        return (FN)this.getTyped(1, FN.class);
    }

    public FN getPpn2_FamilyName() {
        return (FN)this.getTyped(1, FN.class);
    }

    public ST getGivenName() {
        return (ST)this.getTyped(2, ST.class);
    }

    public ST getPpn3_GivenName() {
        return (ST)this.getTyped(2, ST.class);
    }

    public ST getSecondAndFurtherGivenNamesOrInitialsThereof() {
        return (ST)this.getTyped(3, ST.class);
    }

    public ST getPpn4_SecondAndFurtherGivenNamesOrInitialsThereof() {
        return (ST)this.getTyped(3, ST.class);
    }

    public ST getSuffixEgJRorIII() {
        return (ST)this.getTyped(4, ST.class);
    }

    public ST getPpn5_SuffixEgJRorIII() {
        return (ST)this.getTyped(4, ST.class);
    }

    public ST getPrefixEgDR() {
        return (ST)this.getTyped(5, ST.class);
    }

    public ST getPpn6_PrefixEgDR() {
        return (ST)this.getTyped(5, ST.class);
    }

    public IS getDegreeEgMD() {
        return (IS)this.getTyped(6, IS.class);
    }

    public IS getPpn7_DegreeEgMD() {
        return (IS)this.getTyped(6, IS.class);
    }

    public IS getSourceTable() {
        return (IS)this.getTyped(7, IS.class);
    }

    public IS getPpn8_SourceTable() {
        return (IS)this.getTyped(7, IS.class);
    }

    public HD getAssigningAuthority() {
        return (HD)this.getTyped(8, HD.class);
    }

    public HD getPpn9_AssigningAuthority() {
        return (HD)this.getTyped(8, HD.class);
    }

    public ID getNameTypeCode() {
        return (ID)this.getTyped(9, ID.class);
    }

    public ID getPpn10_NameTypeCode() {
        return (ID)this.getTyped(9, ID.class);
    }

    public ST getIdentifierCheckDigit() {
        return (ST)this.getTyped(10, ST.class);
    }

    public ST getPpn11_IdentifierCheckDigit() {
        return (ST)this.getTyped(10, ST.class);
    }

    public ID getCodeIdentifyingTheCheckDigitSchemeEmployed() {
        return (ID)this.getTyped(11, ID.class);
    }

    public ID getPpn12_CodeIdentifyingTheCheckDigitSchemeEmployed() {
        return (ID)this.getTyped(11, ID.class);
    }

    public IS getIdentifierTypeCode() {
        return (IS)this.getTyped(12, IS.class);
    }

    public IS getPpn13_IdentifierTypeCode() {
        return (IS)this.getTyped(12, IS.class);
    }

    public HD getAssigningFacility() {
        return (HD)this.getTyped(13, HD.class);
    }

    public HD getPpn14_AssigningFacility() {
        return (HD)this.getTyped(13, HD.class);
    }

    public TS getDateTimeActionPerformed() {
        return (TS)this.getTyped(14, TS.class);
    }

    public TS getPpn15_DateTimeActionPerformed() {
        return (TS)this.getTyped(14, TS.class);
    }

    public ID getNameRepresentationCode() {
        return (ID)this.getTyped(15, ID.class);
    }

    public ID getPpn16_NameRepresentationCode() {
        return (ID)this.getTyped(15, ID.class);
    }

    public CE getNameContext() {
        return (CE)this.getTyped(16, CE.class);
    }

    public CE getPpn17_NameContext() {
        return (CE)this.getTyped(16, CE.class);
    }

    public DR getNameValidityRange() {
        return (DR)this.getTyped(17, DR.class);
    }

    public DR getPpn18_NameValidityRange() {
        return (DR)this.getTyped(17, DR.class);
    }

    public ID getNameAssemblyOrder() {
        return (ID)this.getTyped(18, ID.class);
    }

    public ID getPpn19_NameAssemblyOrder() {
        return (ID)this.getTyped(18, ID.class);
    }
}

