/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v24.segment.EQP;
import ca.uhn.hl7v2.model.v24.segment.EQU;
import ca.uhn.hl7v2.model.v24.segment.MSH;
import ca.uhn.hl7v2.model.v24.segment.ROL;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LSU_U12
extends AbstractMessage {
    public LSU_U12() {
        this((ModelClassFactory)new DefaultModelClassFactory());
    }

    public LSU_U12(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(EQU.class, true, false);
            this.add(EQP.class, true, true);
            this.add(ROL.class, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating LSU_U12 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.4";
    }

    public MSH getMSH() {
        return (MSH)this.getTyped("MSH", MSH.class);
    }

    public EQU getEQU() {
        return (EQU)this.getTyped("EQU", EQU.class);
    }

    public EQP getEQP() {
        return (EQP)this.getTyped("EQP", EQP.class);
    }

    public EQP getEQP(int rep) {
        return (EQP)this.getTyped("EQP", rep, EQP.class);
    }

    public int getEQPReps() {
        return this.getReps("EQP");
    }

    public List<EQP> getEQPAll() throws HL7Exception {
        return this.getAllAsList("EQP", EQP.class);
    }

    public void insertEQP(EQP structure, int rep) throws HL7Exception {
        super.insertRepetition("EQP", (Structure)structure, rep);
    }

    public EQP insertEQP(int rep) throws HL7Exception {
        return (EQP)super.insertRepetition("EQP", rep);
    }

    public EQP removeEQP(int rep) throws HL7Exception {
        return (EQP)super.removeRepetition("EQP", rep);
    }

    public ROL getROL() {
        return (ROL)this.getTyped("ROL", ROL.class);
    }
}

