/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v24.datatype.CE;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class RXR
extends AbstractSegment {
    public RXR(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(CE.class, true, 1, 250, new Object[]{this.getMessage()}, "Route");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Administration Site");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Administration Device");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Administration Method");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Routing Instruction");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RXR - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public CE getRoute() {
        CE retVal = (CE)this.getTypedField(1, 0);
        return retVal;
    }

    public CE getRxr1_Route() {
        CE retVal = (CE)this.getTypedField(1, 0);
        return retVal;
    }

    public CE getAdministrationSite() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getRxr2_AdministrationSite() {
        CE retVal = (CE)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getAdministrationDevice() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getRxr3_AdministrationDevice() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getAdministrationMethod() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public CE getRxr4_AdministrationMethod() {
        CE retVal = (CE)this.getTypedField(4, 0);
        return retVal;
    }

    public CE getRoutingInstruction() {
        CE retVal = (CE)this.getTypedField(5, 0);
        return retVal;
    }

    public CE getRxr5_RoutingInstruction() {
        CE retVal = (CE)this.getTypedField(5, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new CE(this.getMessage());
            }
            case 1: {
                return new CE(this.getMessage());
            }
            case 2: {
                return new CE(this.getMessage());
            }
            case 3: {
                return new CE(this.getMessage());
            }
            case 4: {
                return new CE(this.getMessage());
            }
        }
        return null;
    }
}

