/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dozer;

import java.lang.reflect.Method;
import org.apache.camel.component.dozer.BaseConverter;
import org.apache.camel.spi.ClassResolver;

public class CustomMapper
extends BaseConverter {
    private ClassResolver resolver;

    public CustomMapper(ClassResolver resolver) {
        this.resolver = resolver;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object convert(Object existingDestinationFieldValue, Object sourceFieldValue, Class<?> destinationClass, Class<?> sourceClass) {
        try {
            Object object = this.mapCustom(sourceFieldValue);
            return object;
        }
        finally {
            this.done();
        }
    }

    Method selectMethod(Class<?> customClass, Object fromType) {
        Method method = null;
        for (Method m : customClass.getDeclaredMethods()) {
            if (m.getReturnType() == null || m.getParameterTypes().length != 1 || !m.getParameterTypes()[0].isAssignableFrom(fromType.getClass())) continue;
            method = m;
            break;
        }
        return method;
    }

    Object mapCustom(Object source) {
        Method mapMethod;
        Object customMapObj;
        String[] params = this.getParameter().split(",");
        String className = params[0];
        String operation = params.length > 1 ? params[1] : null;
        try {
            Class customClass = this.resolver.resolveClass(className);
            customMapObj = customClass.newInstance();
            mapMethod = operation != null ? customClass.getMethod(operation, source.getClass()) : this.selectMethod(customClass, source);
        }
        catch (Exception cnfEx) {
            throw new RuntimeException("Failed to load custom mapping", cnfEx);
        }
        if (mapMethod == null) {
            throw new RuntimeException("No eligible custom mapping methods in " + className);
        }
        try {
            return mapMethod.invoke(customMapObj, source);
        }
        catch (Exception ex) {
            throw new RuntimeException("Error while invoking custom mapping", ex);
        }
    }
}

