/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xmlsecurity.api;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.component.xmlsecurity.api.KeyStoreAndAlias;
import org.apache.camel.component.xmlsecurity.api.XAdESSignatureProperties;
import org.apache.camel.component.xmlsecurity.api.XmlSignatureException;
import org.apache.camel.util.jsse.KeyStoreParameters;

public class DefaultXAdESSignatureProperties
extends XAdESSignatureProperties
implements CamelContextAware {
    private final KeyStoreAndAlias keyStoreAndAlias = new KeyStoreAndAlias();
    private CamelContext context;

    public void setKeystore(KeyStore keystore) {
        this.keyStoreAndAlias.setKeyStore(keystore);
    }

    public void setAlias(String alias) {
        this.keyStoreAndAlias.setAlias(alias);
    }

    public void setKeyStoreParameters(KeyStoreParameters parameters) throws GeneralSecurityException, IOException {
        if (parameters != null) {
            this.keyStoreAndAlias.setKeyStore(parameters.createKeyStore());
        }
    }

    @Override
    protected X509Certificate getSigningCertificate() throws Exception {
        if (this.keyStoreAndAlias.getKeyStore() == null) {
            throw new XmlSignatureException("No keystore has been configured");
        }
        X509Certificate cert = (X509Certificate)this.keyStoreAndAlias.getKeyStore().getCertificate(this.keyStoreAndAlias.getAlias());
        if (cert == null) {
            throw new XmlSignatureException(String.format("No certificate found in keystore for alias '%s'", this.keyStoreAndAlias.getAlias()));
        }
        return cert;
    }

    @Override
    protected X509Certificate[] getSigningCertificateChain() throws Exception {
        return null;
    }

    public CamelContext getCamelContext() {
        return this.context;
    }

    public void setCamelContext(CamelContext context) {
        this.context = context;
    }
}

