/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.gravia.resource.spi;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jboss.gravia.resource.Requirement;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.resource.ResourceIdentity;
import org.jboss.gravia.resource.VersionRange;
import org.jboss.gravia.resource.spi.AbstractResource;

public class AbstractRequirement
implements Requirement {
    private final AbstractResource resource;
    private final String namespace;
    private Map<String, Object> attributes;
    private Map<String, String> directives;
    private String canonicalName;
    private boolean optional;

    public AbstractRequirement(AbstractResource resource, String namespace, Map<String, Object> atts, Map<String, String> dirs) {
        if (resource == null) {
            throw new IllegalArgumentException("Null resource");
        }
        if (namespace == null) {
            throw new IllegalArgumentException("Null namespace");
        }
        this.resource = resource;
        this.namespace = namespace;
        if (atts != null) {
            this.getAttributes().putAll(atts);
        }
        if (dirs != null) {
            this.getDirectives().putAll(dirs);
        }
    }

    @Override
    public <T> T adapt(Class<T> type) {
        AbstractRequirement result = null;
        if (type.isAssignableFrom(this.getClass())) {
            result = this;
        }
        return (T)result;
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public Map<String, String> getDirectives() {
        if (this.directives == null) {
            this.directives = new LinkedHashMap<String, String>();
        }
        return this.resource.isMutable() ? this.directives : Collections.unmodifiableMap(this.directives);
    }

    @Override
    public String getDirective(String key) {
        return this.directives != null ? this.directives.get(key) : null;
    }

    @Override
    public Map<String, Object> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new LinkedHashMap<String, Object>();
        }
        return this.resource.isMutable() ? this.attributes : Collections.unmodifiableMap(this.attributes);
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes != null ? this.attributes.get(key) : null;
    }

    public static VersionRange getVersionRange(Requirement req, String attr) {
        Object value = req.getAttribute(attr);
        return value instanceof String ? new VersionRange((String)value) : (VersionRange)value;
    }

    protected void validate() {
        Object attval = this.getAttribute("version");
        if (attval != null && !(attval instanceof VersionRange)) {
            this.getAttributes().put("version", new VersionRange(attval.toString()));
        }
        String resdir = this.getDirective("resolution");
        this.optional = "optional".equals(resdir);
        this.canonicalName = this.toString();
    }

    public String toString() {
        String result = this.canonicalName;
        if (result == null) {
            ResourceIdentity icap;
            String type;
            String nsval = null;
            if ("gravia.identity".equals(this.getNamespace())) {
                type = "IdentityRequirement";
            } else {
                type = this.getClass().getSimpleName();
                nsval = this.namespace;
            }
            StringBuffer buffer = new StringBuffer(type + "[");
            boolean addcomma = false;
            if (nsval != null) {
                buffer.append(nsval);
                addcomma = true;
            }
            if (!this.getAttributes().isEmpty()) {
                buffer.append(addcomma ? "," : "");
                buffer.append("atts=" + this.attributes);
                addcomma = true;
            }
            if (!this.getDirectives().isEmpty()) {
                buffer.append(addcomma ? "," : "");
                buffer.append("dirs=" + this.directives);
                addcomma = true;
            }
            if ((icap = this.resource.getIdentity()) != null) {
                buffer.append(addcomma ? "," : "");
                buffer.append("[" + icap.getSymbolicName() + ":" + icap.getVersion() + "]");
                addcomma = true;
            } else {
                buffer.append(addcomma ? "," : "");
                buffer.append("[anonymous]");
                addcomma = true;
            }
            buffer.append("]");
            result = buffer.toString();
        }
        return result;
    }
}

