/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.internal.processor;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Exchange;
import org.apache.camel.component.salesforce.SalesforceEndpoint;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.api.dto.AbstractSObjectBase;
import org.apache.camel.component.salesforce.internal.PayloadFormat;
import org.apache.camel.component.salesforce.internal.client.DefaultRestClient;
import org.apache.camel.component.salesforce.internal.client.RestClient;
import org.apache.camel.component.salesforce.internal.processor.AbstractSalesforceProcessor;
import org.apache.camel.util.ServiceHelper;

public abstract class AbstractRestProcessor
extends AbstractSalesforceProcessor {
    protected static final String RESPONSE_CLASS = AbstractRestProcessor.class.getName() + ".responseClass";
    private static final Pattern URL_TEMPLATE = Pattern.compile("\\{([^\\{\\}]+)\\}");
    private RestClient restClient;
    private Map<String, Class<?>> classMap;

    public AbstractRestProcessor(SalesforceEndpoint endpoint) throws SalesforceException {
        super(endpoint);
        PayloadFormat payloadFormat = endpoint.getConfiguration().getFormat();
        this.restClient = new DefaultRestClient(this.httpClient, (String)this.endpointConfigMap.get("apiVersion"), payloadFormat, this.session);
        this.classMap = endpoint.getComponent().getClassMap();
    }

    public void start() throws Exception {
        ServiceHelper.startService((Object)this.restClient);
    }

    public void stop() throws Exception {
        ServiceHelper.stopService((Object)this.restClient);
    }

    @Override
    public final boolean process(Exchange exchange, AsyncCallback callback) {
        try {
            this.processRequest(exchange);
        }
        catch (SalesforceException e) {
            exchange.setException((Throwable)((Object)e));
            callback.done(true);
            return true;
        }
        catch (RuntimeException e) {
            exchange.setException((Throwable)((Object)new SalesforceException(e.getMessage(), e)));
            callback.done(true);
            return true;
        }
        try {
            switch (this.operationName) {
                case GET_VERSIONS: {
                    this.processGetVersions(exchange, callback);
                    break;
                }
                case GET_RESOURCES: {
                    this.processGetResources(exchange, callback);
                    break;
                }
                case GET_GLOBAL_OBJECTS: {
                    this.processGetGlobalObjects(exchange, callback);
                    break;
                }
                case GET_BASIC_INFO: {
                    this.processGetBasicInfo(exchange, callback);
                    break;
                }
                case GET_DESCRIPTION: {
                    this.processGetDescription(exchange, callback);
                    break;
                }
                case GET_SOBJECT: {
                    this.processGetSobject(exchange, callback);
                    break;
                }
                case CREATE_SOBJECT: {
                    this.processCreateSobject(exchange, callback);
                    break;
                }
                case UPDATE_SOBJECT: {
                    this.processUpdateSobject(exchange, callback);
                    break;
                }
                case DELETE_SOBJECT: {
                    this.processDeleteSobject(exchange, callback);
                    break;
                }
                case GET_SOBJECT_WITH_ID: {
                    this.processGetSobjectWithId(exchange, callback);
                    break;
                }
                case UPSERT_SOBJECT: {
                    this.processUpsertSobject(exchange, callback);
                    break;
                }
                case DELETE_SOBJECT_WITH_ID: {
                    this.processDeleteSobjectWithId(exchange, callback);
                    break;
                }
                case GET_BLOB_FIELD: {
                    this.processGetBlobField(exchange, callback);
                    break;
                }
                case QUERY: {
                    this.processQuery(exchange, callback);
                    break;
                }
                case QUERY_MORE: {
                    this.processQueryMore(exchange, callback);
                    break;
                }
                case SEARCH: {
                    this.processSearch(exchange, callback);
                    break;
                }
                case APEX_CALL: {
                    this.processApexCall(exchange, callback);
                    break;
                }
                default: {
                    throw new SalesforceException("Unknow operation name: " + (Object)((Object)this.operationName), null);
                }
            }
        }
        catch (SalesforceException e) {
            exchange.setException((Throwable)((Object)new SalesforceException(String.format("Error processing %s: [%s] \"%s\"", new Object[]{this.operationName, e.getStatusCode(), e.getMessage()}), (Throwable)((Object)e))));
            callback.done(true);
            return true;
        }
        catch (RuntimeException e) {
            exchange.setException((Throwable)((Object)new SalesforceException(String.format("Unexpected Error processing %s: \"%s\"", new Object[]{this.operationName, e.getMessage()}), e)));
            callback.done(true);
            return true;
        }
        return false;
    }

    private void processGetVersions(final Exchange exchange, final AsyncCallback callback) {
        this.restClient.getVersions(new RestClient.ResponseCallback(){

            @Override
            public void onResponse(InputStream response, SalesforceException exception) {
                AbstractRestProcessor.this.processResponse(exchange, response, exception, callback);
            }
        });
    }

    private void processGetResources(final Exchange exchange, final AsyncCallback callback) {
        this.restClient.getResources(new RestClient.ResponseCallback(){

            @Override
            public void onResponse(InputStream response, SalesforceException exception) {
                AbstractRestProcessor.this.processResponse(exchange, response, exception, callback);
            }
        });
    }

    private void processGetGlobalObjects(final Exchange exchange, final AsyncCallback callback) {
        this.restClient.getGlobalObjects(new RestClient.ResponseCallback(){

            @Override
            public void onResponse(InputStream response, SalesforceException exception) {
                AbstractRestProcessor.this.processResponse(exchange, response, exception, callback);
            }
        });
    }

    private void processGetBasicInfo(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        String sObjectName = this.getParameter("sObjectName", exchange, true, false);
        this.restClient.getBasicInfo(sObjectName, new RestClient.ResponseCallback(){

            @Override
            public void onResponse(InputStream response, SalesforceException exception) {
                AbstractRestProcessor.this.processResponse(exchange, response, exception, callback);
            }
        });
    }

    private void processGetDescription(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        String sObjectName = this.getParameter("sObjectName", exchange, true, false);
        this.restClient.getDescription(sObjectName, new RestClient.ResponseCallback(){

            @Override
            public void onResponse(InputStream response, SalesforceException exception) {
                AbstractRestProcessor.this.processResponse(exchange, response, exception, callback);
            }
        });
    }

    private void processGetSobject(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        String sObjectIdValue;
        String sObjectName;
        final AbstractSObjectBase sObjectBase = (AbstractSObjectBase)exchange.getIn().getBody(AbstractSObjectBase.class);
        if (sObjectBase != null) {
            sObjectName = sObjectBase.getClass().getSimpleName();
            sObjectIdValue = sObjectBase.getId();
        } else {
            sObjectName = this.getParameter("sObjectName", exchange, false, false);
            sObjectIdValue = this.getParameter("sObjectId", exchange, true, false);
        }
        final String sObjectId = sObjectIdValue;
        this.setResponseClass(exchange, sObjectName);
        String fieldsValue = this.getParameter("sObjectFields", exchange, false, true);
        String[] fields = null;
        if (fieldsValue != null) {
            fields = fieldsValue.split(",");
        }
        this.restClient.getSObject(sObjectName, sObjectId, fields, new RestClient.ResponseCallback(){

            @Override
            public void onResponse(InputStream response, SalesforceException exception) {
                AbstractRestProcessor.this.processResponse(exchange, response, exception, callback);
                AbstractRestProcessor.this.restoreFields(exchange, sObjectBase, sObjectId, null, null);
            }
        });
    }

    private void processCreateSobject(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        AbstractSObjectBase sObjectBase = (AbstractSObjectBase)exchange.getIn().getBody(AbstractSObjectBase.class);
        String sObjectName = sObjectBase != null ? sObjectBase.getClass().getSimpleName() : this.getParameter("sObjectName", exchange, false, false);
        this.restClient.createSObject(sObjectName, this.getRequestStream(exchange), new RestClient.ResponseCallback(){

            @Override
            public void onResponse(InputStream response, SalesforceException exception) {
                AbstractRestProcessor.this.processResponse(exchange, response, exception, callback);
            }
        });
    }

    private void processUpdateSobject(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        String sObjectId;
        String sObjectName;
        final AbstractSObjectBase sObjectBase = (AbstractSObjectBase)exchange.getIn().getBody(AbstractSObjectBase.class);
        if (sObjectBase != null) {
            sObjectName = sObjectBase.getClass().getSimpleName();
            sObjectId = sObjectBase.getId();
            sObjectBase.clearBaseFields();
        } else {
            sObjectName = this.getParameter("sObjectName", exchange, false, false);
            sObjectId = this.getParameter("sObjectId", exchange, false, false);
        }
        final String finalsObjectId = sObjectId;
        this.restClient.updateSObject(sObjectName, sObjectId, this.getRequestStream(exchange), new RestClient.ResponseCallback(){

            @Override
            public void onResponse(InputStream response, SalesforceException exception) {
                AbstractRestProcessor.this.processResponse(exchange, response, exception, callback);
                AbstractRestProcessor.this.restoreFields(exchange, sObjectBase, finalsObjectId, null, null);
            }
        });
    }

    private void processDeleteSobject(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        String sObjectIdValue;
        String sObjectName;
        final AbstractSObjectBase sObjectBase = (AbstractSObjectBase)exchange.getIn().getBody(AbstractSObjectBase.class);
        if (sObjectBase != null) {
            sObjectName = sObjectBase.getClass().getSimpleName();
            sObjectIdValue = sObjectBase.getId();
        } else {
            sObjectName = this.getParameter("sObjectName", exchange, false, false);
            sObjectIdValue = this.getParameter("sObjectId", exchange, true, false);
        }
        final String sObjectId = sObjectIdValue;
        this.restClient.deleteSObject(sObjectName, sObjectId, new RestClient.ResponseCallback(){

            @Override
            public void onResponse(InputStream response, SalesforceException exception) {
                AbstractRestProcessor.this.processResponse(exchange, response, exception, callback);
                AbstractRestProcessor.this.restoreFields(exchange, sObjectBase, sObjectId, null, null);
            }
        });
    }

    private void processGetSobjectWithId(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        String sObjectExtIdValue;
        String sObjectName;
        Object oldValue = null;
        final String sObjectExtIdName = this.getParameter("sObjectIdName", exchange, false, false);
        final AbstractSObjectBase sObjectBase = (AbstractSObjectBase)exchange.getIn().getBody(AbstractSObjectBase.class);
        if (sObjectBase != null) {
            sObjectName = sObjectBase.getClass().getSimpleName();
            oldValue = this.getAndClearPropertyValue(sObjectBase, sObjectExtIdName);
            sObjectExtIdValue = oldValue.toString();
        } else {
            sObjectName = this.getParameter("sObjectName", exchange, false, false);
            sObjectExtIdValue = this.getParameter("sObjectIdValue", exchange, true, false);
        }
        this.setResponseClass(exchange, sObjectName);
        final Object finalOldValue = oldValue;
        this.restClient.getSObjectWithId(sObjectName, sObjectExtIdName, sObjectExtIdValue, new RestClient.ResponseCallback(){

            @Override
            public void onResponse(InputStream response, SalesforceException exception) {
                AbstractRestProcessor.this.processResponse(exchange, response, exception, callback);
                AbstractRestProcessor.this.restoreFields(exchange, sObjectBase, null, sObjectExtIdName, finalOldValue);
            }
        });
    }

    private void processUpsertSobject(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        String sObjectExtIdValue;
        String sObjectName;
        final String sObjectExtIdName = this.getParameter("sObjectIdName", exchange, false, false);
        Object oldValue = null;
        final AbstractSObjectBase sObjectBase = (AbstractSObjectBase)exchange.getIn().getBody(AbstractSObjectBase.class);
        if (sObjectBase != null) {
            sObjectName = sObjectBase.getClass().getSimpleName();
            oldValue = this.getAndClearPropertyValue(sObjectBase, sObjectExtIdName);
            sObjectExtIdValue = oldValue.toString();
            sObjectBase.clearBaseFields();
        } else {
            sObjectName = this.getParameter("sObjectName", exchange, false, false);
            sObjectExtIdValue = this.getParameter("sObjectIdValue", exchange, false, false);
        }
        final Object finalOldValue = oldValue;
        this.restClient.upsertSObject(sObjectName, sObjectExtIdName, sObjectExtIdValue, this.getRequestStream(exchange), new RestClient.ResponseCallback(){

            @Override
            public void onResponse(InputStream response, SalesforceException exception) {
                AbstractRestProcessor.this.processResponse(exchange, response, exception, callback);
                AbstractRestProcessor.this.restoreFields(exchange, sObjectBase, null, sObjectExtIdName, finalOldValue);
            }
        });
    }

    private void processDeleteSobjectWithId(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        String sObjectExtIdValue;
        String sObjectName;
        final String sObjectExtIdName = this.getParameter("sObjectIdName", exchange, false, false);
        Object oldValue = null;
        final AbstractSObjectBase sObjectBase = (AbstractSObjectBase)exchange.getIn().getBody(AbstractSObjectBase.class);
        if (sObjectBase != null) {
            sObjectName = sObjectBase.getClass().getSimpleName();
            oldValue = this.getAndClearPropertyValue(sObjectBase, sObjectExtIdName);
            sObjectExtIdValue = oldValue.toString();
        } else {
            sObjectName = this.getParameter("sObjectName", exchange, false, false);
            sObjectExtIdValue = this.getParameter("sObjectIdValue", exchange, true, false);
        }
        final Object finalOldValue = oldValue;
        this.restClient.deleteSObjectWithId(sObjectName, sObjectExtIdName, sObjectExtIdValue, new RestClient.ResponseCallback(){

            @Override
            public void onResponse(InputStream response, SalesforceException exception) {
                AbstractRestProcessor.this.processResponse(exchange, response, exception, callback);
                AbstractRestProcessor.this.restoreFields(exchange, sObjectBase, null, sObjectExtIdName, finalOldValue);
            }
        });
    }

    private void processGetBlobField(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        String sObjectIdValue;
        String sObjectName;
        String sObjectBlobFieldName = this.getParameter("sObjectBlobFieldName", exchange, false, false);
        final AbstractSObjectBase sObjectBase = (AbstractSObjectBase)exchange.getIn().getBody(AbstractSObjectBase.class);
        if (sObjectBase != null) {
            sObjectName = sObjectBase.getClass().getSimpleName();
            sObjectIdValue = sObjectBase.getId();
        } else {
            sObjectName = this.getParameter("sObjectName", exchange, false, false);
            sObjectIdValue = this.getParameter("sObjectId", exchange, true, false);
        }
        final String sObjectId = sObjectIdValue;
        this.restClient.getBlobField(sObjectName, sObjectId, sObjectBlobFieldName, new RestClient.ResponseCallback(){

            @Override
            public void onResponse(InputStream response, SalesforceException exception) {
                AbstractRestProcessor.this.processResponse(exchange, response, exception, callback);
                AbstractRestProcessor.this.restoreFields(exchange, sObjectBase, sObjectId, null, null);
            }
        });
    }

    private void processQuery(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        String sObjectQuery = this.getParameter("sObjectQuery", exchange, true, false);
        this.setResponseClass(exchange, null);
        this.restClient.query(sObjectQuery, new RestClient.ResponseCallback(){

            @Override
            public void onResponse(InputStream response, SalesforceException exception) {
                AbstractRestProcessor.this.processResponse(exchange, response, exception, callback);
            }
        });
    }

    private void processQueryMore(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        String nextRecordsUrl = this.getParameter("sObjectQuery", exchange, true, false);
        this.setResponseClass(exchange, null);
        this.restClient.queryMore(nextRecordsUrl, new RestClient.ResponseCallback(){

            @Override
            public void onResponse(InputStream response, SalesforceException exception) {
                AbstractRestProcessor.this.processResponse(exchange, response, exception, callback);
            }
        });
    }

    private void processSearch(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        String sObjectSearch = this.getParameter("sObjectSearch", exchange, true, false);
        this.restClient.search(sObjectSearch, new RestClient.ResponseCallback(){

            @Override
            public void onResponse(InputStream response, SalesforceException exception) {
                AbstractRestProcessor.this.processResponse(exchange, response, exception, callback);
            }
        });
    }

    private void processApexCall(final Exchange exchange, final AsyncCallback callback) throws SalesforceException {
        String apexUrl = this.getApexUrl(exchange);
        String apexMethod = this.getParameter("apexMethod", exchange, false, true);
        if (apexMethod == null) {
            apexMethod = "GET";
            this.log.debug("Using HTTP GET method by default for APEX REST call for {}", (Object)apexUrl);
        }
        Map<String, Object> queryParams = this.getQueryParams(exchange);
        this.setResponseClass(exchange, this.getParameter("sObjectName", exchange, false, true));
        Object requestBody = exchange.getIn().getBody();
        InputStream requestDto = requestBody != null && !(requestBody instanceof Map) ? this.getRequestStream(exchange) : null;
        this.restClient.apexCall(apexMethod, apexUrl, queryParams, requestDto, new RestClient.ResponseCallback(){

            @Override
            public void onResponse(InputStream response, SalesforceException exception) {
                AbstractRestProcessor.this.processResponse(exchange, response, exception, callback);
            }
        });
    }

    private String getApexUrl(Exchange exchange) throws SalesforceException {
        String apexUrl = this.getParameter("apexUrl", exchange, false, false);
        Matcher matcher = URL_TEMPLATE.matcher(apexUrl);
        StringBuilder result = new StringBuilder();
        int start = 0;
        while (matcher.find()) {
            result.append(apexUrl.substring(start, matcher.start()));
            start = matcher.end();
            String parameterName = matcher.group(1);
            Object value = exchange.getIn().getHeader(parameterName);
            if (value == null) {
                throw new IllegalArgumentException("Missing APEX URL template header " + parameterName);
            }
            try {
                result.append(URLEncoder.encode(String.valueOf(value), "UTF-8").replaceAll("\\+", "%20"));
            }
            catch (UnsupportedEncodingException e) {
                throw new SalesforceException("Unexpected error: " + e.getMessage(), e);
            }
        }
        if (start != 0) {
            result.append(apexUrl.substring(start));
            String resolvedUrl = result.toString();
            this.log.debug("Resolved APEX URL {} to {}", (Object)apexUrl, (Object)resolvedUrl);
            return resolvedUrl;
        }
        return apexUrl;
    }

    private Map<String, Object> getQueryParams(Exchange exchange) {
        HashMap<String, Object> queryParams = new HashMap<String, Object>(this.endpoint.getConfiguration().getApexQueryParams());
        for (Map.Entry entry : exchange.getIn().getHeaders().entrySet()) {
            if (!((String)entry.getKey()).startsWith("apexQueryParam.")) continue;
            queryParams.put(((String)entry.getKey()).substring("apexQueryParam.".length()), entry.getValue());
        }
        Object body = exchange.getIn().getBody();
        if (body instanceof Map) {
            queryParams.putAll((Map)body);
        }
        this.log.debug("Using APEX query params {}", queryParams);
        return queryParams;
    }

    private void restoreFields(Exchange exchange, AbstractSObjectBase sObjectBase, String sObjectId, String sObjectExtIdName, Object oldValue) {
        if (sObjectBase != null) {
            if (sObjectId != null) {
                sObjectBase.setId(sObjectId);
            }
            if (sObjectExtIdName != null && oldValue != null) {
                try {
                    this.setPropertyValue(sObjectBase, sObjectExtIdName, oldValue);
                }
                catch (SalesforceException e) {
                    exchange.setException((Throwable)((Object)e));
                }
            }
        }
    }

    private void setPropertyValue(AbstractSObjectBase sObjectBase, String name, Object value) throws SalesforceException {
        try {
            Method setMethod = sObjectBase.getClass().getMethod("set" + name, value.getClass());
            setMethod.invoke((Object)sObjectBase, value);
        }
        catch (NoSuchMethodException e) {
            throw new SalesforceException(String.format("SObject %s does not have a field %s", sObjectBase.getClass().getName(), name), e);
        }
        catch (InvocationTargetException e) {
            throw new SalesforceException(String.format("Error setting value %s.%s", sObjectBase.getClass().getSimpleName(), name), e);
        }
        catch (IllegalAccessException e) {
            throw new SalesforceException(String.format("Error accessing value %s.%s", sObjectBase.getClass().getSimpleName(), name), e);
        }
    }

    private Object getAndClearPropertyValue(AbstractSObjectBase sObjectBase, String propertyName) throws SalesforceException {
        try {
            Method getMethod = sObjectBase.getClass().getMethod("get" + propertyName, new Class[0]);
            Object value = getMethod.invoke((Object)sObjectBase, new Object[0]);
            Method setMethod = sObjectBase.getClass().getMethod("set" + propertyName, getMethod.getReturnType());
            setMethod.invoke((Object)sObjectBase, new Object[]{null});
            return value;
        }
        catch (NoSuchMethodException e) {
            throw new SalesforceException(String.format("SObject %s does not have a field %s", sObjectBase.getClass().getSimpleName(), propertyName), e);
        }
        catch (InvocationTargetException e) {
            throw new SalesforceException(String.format("Error getting/setting value %s.%s", sObjectBase.getClass().getSimpleName(), propertyName), e);
        }
        catch (IllegalAccessException e) {
            throw new SalesforceException(String.format("Error accessing value %s.%s", sObjectBase.getClass().getSimpleName(), propertyName), e);
        }
    }

    protected abstract void processRequest(Exchange var1) throws SalesforceException;

    protected abstract InputStream getRequestStream(Exchange var1) throws SalesforceException;

    private void setResponseClass(Exchange exchange, String sObjectName) throws SalesforceException {
        Class sObjectClass;
        if (sObjectName != null) {
            sObjectClass = this.classMap.get(sObjectName);
            if (null == sObjectClass) {
                throw new SalesforceException(String.format("No class found for SObject %s", sObjectName), null);
            }
        } else {
            String className = this.getParameter("sObjectClass", exchange, false, false);
            try {
                sObjectClass = this.endpoint.getComponent().getCamelContext().getClassResolver().resolveMandatoryClass(className);
            }
            catch (ClassNotFoundException e) {
                throw new SalesforceException(String.format("SObject class not found %s, %s", className, e.getMessage()), e);
            }
        }
        exchange.setProperty(RESPONSE_CLASS, sObjectClass);
    }

    protected abstract void processResponse(Exchange var1, InputStream var2, SalesforceException var3, AsyncCallback var4);
}

