/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.protocol.impl;

import ca.uhn.hl7v2.AcknowledgmentCode;
import ca.uhn.hl7v2.ErrorCode;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.parser.GenericParser;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.protocol.AcceptValidator;
import ca.uhn.hl7v2.protocol.ProcessorContext;
import ca.uhn.hl7v2.protocol.Transportable;
import ca.uhn.hl7v2.protocol.impl.TransportableImpl;
import ca.uhn.hl7v2.util.DeepCopy;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcceptAcknowledger {
    private static final Logger log = LoggerFactory.getLogger(AcceptAcknowledger.class);
    private static Parser ourParser = new GenericParser();

    public static AcceptACK validate(ProcessorContext theContext, Transportable theMessage) throws HL7Exception {
        AcceptACK ruling = null;
        AcceptValidator[] validators = theContext.getValidators();
        for (int i = 0; i < validators.length && ruling == null; ++i) {
            AcceptValidator.AcceptRuling vr = validators[i].check(theMessage);
            if (vr.isAcceptable()) continue;
            String description = vr.getReasons().length > 0 ? vr.getReasons()[0] : null;
            Transportable ack = AcceptAcknowledger.makeAcceptAck(theMessage, vr.getAckCode(), ErrorCode.errorCodeFor(vr.getErrorCode()), description);
            ruling = new AcceptACK(false, ack);
        }
        if (ruling == null) {
            try {
                theContext.getSafeStorage().store(theMessage);
                Transportable ack = AcceptAcknowledger.makeAcceptAck(theMessage, "CA", ErrorCode.MESSAGE_ACCEPTED, "");
                ruling = new AcceptACK(true, ack);
            }
            catch (HL7Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                Transportable ack = AcceptAcknowledger.makeAcceptAck(theMessage, "CR", ErrorCode.APPLICATION_INTERNAL_ERROR, e.getMessage());
                ruling = new AcceptACK(false, ack);
            }
        }
        return ruling;
    }

    private static Transportable makeAcceptAck(Transportable theMessage, String theAckCode, ErrorCode theErrorCode, String theDescription) throws HL7Exception {
        Segment header = ourParser.getCriticalResponseData(theMessage.getMessage());
        Message dummy = header.getMessage();
        DeepCopy.copy(header, (Segment)dummy.get("MSH"));
        try {
            HL7Exception hl7e = new HL7Exception(theDescription, theErrorCode);
            AcknowledgmentCode code = theAckCode == null ? AcknowledgmentCode.CR : AcknowledgmentCode.valueOf(theAckCode);
            Message out = dummy.generateACK(code, hl7e);
            String originalEncoding = ourParser.getEncoding(theMessage.getMessage());
            String ackText = ourParser.encode(out, originalEncoding);
            return new TransportableImpl(ackText);
        }
        catch (IOException e) {
            throw new HL7Exception(e);
        }
    }

    public static class AcceptACK {
        private Transportable myAck;
        private boolean myIsAcceptable;

        public AcceptACK(boolean isAcceptable, Transportable theAck) {
            this.myIsAcceptable = isAcceptable;
            this.myAck = theAck;
        }

        public boolean isAcceptable() {
            return this.myIsAcceptable;
        }

        public Transportable getMessage() {
            return this.myAck;
        }
    }
}

