/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.component.sap;

import com.sap.conn.jco.JCoDestination;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.SynchronizationAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DestinationRfcTransactionHandler
extends SynchronizationAdapter {
    public static final String TID_HANDLER_MAP_PROPERTY_KEY = DestinationRfcTransactionHandler.class.getName() + ".tidHandlerMap";
    private static final Logger LOG = LoggerFactory.getLogger(DestinationRfcTransactionHandler.class);
    private JCoDestination destination;
    private String tid;

    public static String getTID(Exchange exchange, JCoDestination destination) throws Exception {
        DestinationRfcTransactionHandler tidHandler;
        HashMap<String, DestinationRfcTransactionHandler> tidHandlerMap = (HashMap<String, DestinationRfcTransactionHandler>)exchange.getProperty(TID_HANDLER_MAP_PROPERTY_KEY, Map.class);
        if (tidHandlerMap == null) {
            tidHandlerMap = new HashMap<String, DestinationRfcTransactionHandler>();
            exchange.setProperty(TID_HANDLER_MAP_PROPERTY_KEY, tidHandlerMap);
        }
        if ((tidHandler = (DestinationRfcTransactionHandler)((Object)tidHandlerMap.get(destination.getDestinationName()))) != null) {
            return tidHandler.getTID();
        }
        tidHandler = new DestinationRfcTransactionHandler(destination);
        tidHandlerMap.put(destination.getDestinationName(), tidHandler);
        exchange.getUnitOfWork().addSynchronization((Synchronization)tidHandler);
        return tidHandler.getTID();
    }

    private DestinationRfcTransactionHandler(JCoDestination destination) {
        if (destination == null) {
            throw new IllegalArgumentException("destination argument can not be null");
        }
        this.destination = destination;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.destination.getDestinationName() == null ? 0 : this.destination.getDestinationName().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        DestinationRfcTransactionHandler other = (DestinationRfcTransactionHandler)((Object)obj);
        return !(this.destination == null ? other.destination != null : !this.destination.getDestinationName().equals(other.destination.getDestinationName()));
    }

    protected String getTID() throws Exception {
        if (this.tid == null) {
            this.tid = this.destination.createTID();
        }
        return this.tid;
    }

    protected void confirmTID() throws Exception {
        this.destination.confirmTID(this.tid);
    }

    public void onComplete(Exchange exchange) {
        try {
            this.confirmTID();
        }
        catch (Exception e) {
            LOG.warn("Failed to confirm transaction id '" + this.tid + "': This exception will be ignored", (Throwable)e);
        }
    }

    public void onFailure(Exchange exchange) {
        try {
            this.confirmTID();
        }
        catch (Exception e) {
            LOG.warn("Failed to confirm transaction id '" + this.tid + "': This exception will be ignored", (Throwable)e);
        }
    }
}

