/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.component.sap;

import com.sap.conn.jco.JCoContext;
import com.sap.conn.jco.JCoDestination;
import org.apache.camel.Exchange;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.SynchronizationAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DestinationSapStatefulSessionHandler
extends SynchronizationAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(DestinationSapStatefulSessionHandler.class);
    private JCoDestination destination;

    public static void ensureSapStatefulSessionHasBegunAndIsHandled(Exchange exchange, JCoDestination destination) {
        DestinationSapStatefulSessionHandler sessionHandler = new DestinationSapStatefulSessionHandler(destination);
        if (!exchange.getUnitOfWork().containsSynchronization((Synchronization)sessionHandler)) {
            sessionHandler.begin();
            exchange.getUnitOfWork().addSynchronization((Synchronization)sessionHandler);
        }
    }

    private DestinationSapStatefulSessionHandler(JCoDestination destination) {
        this.destination = destination;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.destination == null ? 0 : this.destination.getDestinationName().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        DestinationSapStatefulSessionHandler other = (DestinationSapStatefulSessionHandler)((Object)obj);
        return !(this.destination == null ? other.destination != null : !this.destination.getDestinationName().equals(other.destination.getDestinationName()));
    }

    protected void begin() {
        JCoContext.begin((JCoDestination)this.destination);
        LOG.debug("Began SAP stateful session for destination '{}'", (Object)this.destination.getDestinationName());
    }

    public void end() {
        try {
            JCoContext.end((JCoDestination)this.destination);
            LOG.debug("Committed SAP Transaction for destination '{}'", (Object)this.destination.getDestinationName());
        }
        catch (Exception e) {
            LOG.warn("Failed to end SAP stateful session. This exception will be ignored.", (Throwable)e);
        }
    }

    public void onComplete(Exchange exchange) {
        this.end();
    }

    public void onFailure(Exchange exchange) {
        this.end();
    }
}

