/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.component.sap;

import com.sap.conn.jco.JCoDestination;
import org.apache.camel.Exchange;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.support.SynchronizationAdapter;
import org.fusesource.camel.component.sap.util.RfcUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DestinationSapTransactionHandler
extends SynchronizationAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(DestinationSapTransactionHandler.class);
    private JCoDestination destination;

    public static void ensureSapTransactionHasBegunAndIsHandled(Exchange exchange, JCoDestination destination) {
        DestinationSapTransactionHandler transaction = new DestinationSapTransactionHandler(destination);
        if (!exchange.getUnitOfWork().containsSynchronization((Synchronization)transaction)) {
            transaction.begin();
            exchange.getUnitOfWork().addSynchronization((Synchronization)transaction);
        }
    }

    private DestinationSapTransactionHandler(JCoDestination destination) {
        this.destination = destination;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.destination == null ? 0 : this.destination.getDestinationName().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        DestinationSapTransactionHandler other = (DestinationSapTransactionHandler)((Object)obj);
        return !(this.destination == null ? other.destination != null : !this.destination.getDestinationName().equals(other.destination.getDestinationName()));
    }

    protected void begin() {
        RfcUtil.beginTransaction(this.destination);
        LOG.debug("Began SAP Transaction for destination '{}'", (Object)this.destination.getDestinationName());
    }

    public void commit() throws Exception {
        RfcUtil.commitTransaction(this.destination);
        LOG.debug("Committed SAP Transaction for destination '{}'", (Object)this.destination.getDestinationName());
    }

    protected void rollback() throws Exception {
        RfcUtil.rollbackTransaction(this.destination);
        LOG.debug("Rolledback SAP Transaction for destination '{}'", (Object)this.destination.getDestinationName());
    }

    public void onComplete(Exchange exchange) {
        try {
            this.commit();
        }
        catch (Exception e) {
            LOG.warn("Failed to commit SAP Transaction. This exception will be ignored.", (Throwable)e);
        }
    }

    public void onFailure(Exchange exchange) {
        try {
            this.rollback();
        }
        catch (Exception e) {
            LOG.warn("Failed to rollback SAP Transaction. This exception will be ignored.", (Throwable)e);
        }
    }
}

