/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.component.sap;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.impl.DefaultProducer;
import org.fusesource.camel.component.sap.DestinationRfcTransactionHandler;
import org.fusesource.camel.component.sap.SapQueuedIDocListDestinationEndpoint;
import org.fusesource.camel.component.sap.model.idoc.DocumentList;
import org.fusesource.camel.component.sap.util.IDocUtil;
import org.fusesource.camel.component.sap.util.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SapQueuedIDocListProducer
extends DefaultProducer {
    private static final transient Logger LOG = LoggerFactory.getLogger(SapQueuedIDocListProducer.class);

    public SapQueuedIDocListProducer(SapQueuedIDocListDestinationEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        DocumentList documentList = (DocumentList)exchange.getIn().getBody(DocumentList.class);
        if (documentList == null) {
            LOG.warn("Exchange input message body does not contain IDoc document list");
            return;
        }
        if (LOG.isDebugEnabled()) {
            try {
                LOG.debug("Sending IDoc document list to ''{}''", (Object)this.getEndpoint().getEndpointUri());
                LOG.debug("Document: " + (documentList == null ? documentList : Util.marshal(documentList)));
            }
            catch (Exception e) {
                LOG.warn("Failed to log request", (Throwable)e);
            }
        }
        String tid = DestinationRfcTransactionHandler.getTID(exchange, this.getEndpoint().getDestination());
        IDocUtil.sendDocumentList(this.getEndpoint().getDestination(), documentList, tid, this.getEndpoint().getQueueName());
    }

    public SapQueuedIDocListDestinationEndpoint getEndpoint() {
        return (SapQueuedIDocListDestinationEndpoint)super.getEndpoint();
    }
}

