/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.component.sap;

import com.sap.conn.jco.server.JCoServer;
import org.apache.camel.Component;
import org.apache.camel.Producer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.fusesource.camel.component.sap.SapRfcServerComponent;
import org.fusesource.camel.component.sap.model.rfc.Structure;
import org.fusesource.camel.component.sap.util.RfcUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SapRfcServerEndpoint
extends DefaultEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(SapRfcServerEndpoint.class);
    @UriPath(name="server", description="Specifies the server this endpoint receives an SAP request from")
    @Metadata(required="true")
    protected String serverName;
    @UriPath(name="rfc", description="Specifies the Remote Function Module this endpoint handles an SAP request for")
    @Metadata(required="true")
    protected String rfcName;
    @UriParam(name="stateful", description="When true, specifies that this endpoint will initiate an SAP stateful session", defaultValue="false")
    protected boolean stateful;

    public SapRfcServerEndpoint() {
    }

    public SapRfcServerEndpoint(String endpointUri, Component component) {
        super(endpointUri, component);
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getRfcName() {
        return this.rfcName;
    }

    public void setRfcName(String rfcName) {
        this.rfcName = rfcName;
    }

    public boolean isStateful() {
        return this.stateful;
    }

    public void setStateful(boolean stateful) {
        this.stateful = stateful;
    }

    public Producer createProducer() throws Exception {
        throw new UnsupportedOperationException("Endpoint '" + this.getEndpointUri() + "' does not support producers");
    }

    public boolean isSingleton() {
        return true;
    }

    public Structure createResponse() throws Exception {
        return RfcUtil.getResponse(this.getServer().getRepository(), this.getRfcName());
    }

    public SapRfcServerComponent getComponent() {
        return (SapRfcServerComponent)super.getComponent();
    }

    protected JCoServer getServer() {
        try {
            return this.getComponent().getServer(this.serverName);
        }
        catch (Exception e) {
            LOG.warn("Failed to get server object for endpoint '" + this.getEndpointUri() + "'. This exception will be ignored.", (Throwable)e);
            return null;
        }
    }
}

