/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.security;

import java.io.IOException;
import java.util.HashMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.security.ClientLoginModule;
import org.wildfly.extension.camel.security.SecurityActions;

public final class ClientLoginContext {
    private ClientLoginContext() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LoginContext newLoginContext(final String username, final char[] password) throws LoginException {
        String configurationName = "WildFly-Camel";
        CallbackHandler cbh = new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (Callback current : callbacks) {
                    if (current instanceof NameCallback) {
                        ((NameCallback)current).setName(username);
                        continue;
                    }
                    if (current instanceof PasswordCallback) {
                        ((PasswordCallback)current).setPassword(password);
                        continue;
                    }
                    throw new UnsupportedCallbackException(current);
                }
            }
        };
        Configuration config = new Configuration(){

            @Override
            public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
                if (!"WildFly-Camel".equals(name)) {
                    throw new IllegalArgumentException("Unexpected configuration name '" + name + "'");
                }
                HashMap<String, String> options = new HashMap<String, String>();
                options.put("multi-threaded", "true");
                options.put("restore-login-identity", "true");
                AppConfigurationEntry clmEntry = new AppConfigurationEntry(ClientLoginModule.class.getName(), AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
                return new AppConfigurationEntry[]{clmEntry};
            }
        };
        ClassLoader tccl = SecurityActions.getContextClassLoader();
        try {
            if (!(tccl instanceof ModuleClassLoader)) {
                ClassLoader modcl = ClientLoginContext.class.getClassLoader();
                SecurityActions.setContextClassLoader(modcl);
            }
            LoginContext loginContext = new LoginContext("WildFly-Camel", new Subject(), cbh, config);
            return loginContext;
        }
        finally {
            SecurityActions.setContextClassLoader(tccl);
        }
    }
}

