/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mail;

import java.util.Date;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.MimeMessage;
import org.apache.camel.component.mail.DefaultAuthenticator;
import org.apache.camel.component.mail.JavaMailSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJavaMailSender
implements JavaMailSender {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultJavaMailSender.class);
    private Properties javaMailProperties;
    private String host;
    private String username;
    private String password;
    private int port = -1;
    private String protocol;
    private Session session;

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public void setHost(String host) {
        this.host = host;
    }

    @Override
    public Properties getJavaMailProperties() {
        if (this.javaMailProperties == null) {
            this.javaMailProperties = new Properties();
        }
        return this.javaMailProperties;
    }

    @Override
    public void setJavaMailProperties(Properties javaMailProperties) {
        this.javaMailProperties = javaMailProperties;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public Session getSession() {
        if (this.session == null) {
            this.session = Session.getInstance((Properties)this.getJavaMailProperties(), (Authenticator)new DefaultAuthenticator(this.username, this.password));
        }
        return this.session;
    }

    @Override
    public void setSession(Session session) {
        this.session = session;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(MimeMessage mimeMessage) throws MessagingException {
        Transport transport = this.getTransport(this.getSession());
        LOG.debug("Connecting to {}:{}", (Object)this.host, (Object)this.port);
        transport.connect(this.getHost(), this.getPort(), this.getUsername(), this.getPassword());
        try {
            if (mimeMessage.getSentDate() == null) {
                mimeMessage.setSentDate(new Date());
            }
            String messageId = mimeMessage.getMessageID();
            mimeMessage.saveChanges();
            if (messageId != null) {
                mimeMessage.setHeader("Message-ID", messageId);
            }
            LOG.debug("Sending MimMessage: {} using host: {}", (Object)mimeMessage, (Object)this.host);
            transport.sendMessage((Message)mimeMessage, mimeMessage.getAllRecipients());
        }
        finally {
            try {
                transport.close();
            }
            catch (MessagingException e) {
                LOG.warn("Error closing transport to host " + this.host + ". This exception will be ignored.", (Throwable)e);
            }
        }
    }

    protected Transport getTransport(Session session) throws NoSuchProviderException {
        return session.getTransport(this.getProtocol());
    }
}

