/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.util.IOHelper;

public class GzipDataFormat
implements DataFormat {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        InputStream is = exchange.getContext().getTypeConverter().mandatoryConvertTo(InputStream.class, exchange, graph);
        GZIPOutputStream zipOutput = new GZIPOutputStream(stream);
        try {
            IOHelper.copy(is, zipOutput);
        }
        catch (Throwable throwable) {
            IOHelper.close(is, zipOutput);
            throw throwable;
        }
        IOHelper.close(is, zipOutput);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        byte[] byArray;
        InputStream is = exchange.getIn().getMandatoryBody(InputStream.class);
        GZIPInputStream unzipInput = null;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            unzipInput = new GZIPInputStream(is);
            IOHelper.copy(unzipInput, bos);
            byArray = bos.toByteArray();
        }
        catch (Throwable throwable) {
            IOHelper.close(unzipInput, is);
            throw throwable;
        }
        IOHelper.close(unzipInput, is);
        return byArray;
    }
}

