/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.elasticsearch.aggregation;

import org.apache.camel.Exchange;
import org.apache.camel.InvalidPayloadRuntimeException;
import org.apache.camel.processor.aggregate.AggregationStrategy;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.bulk.BulkRequest;

public class BulkRequestAggregationStrategy
implements AggregationStrategy {
    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
        Object objBody = newExchange.getIn().getBody();
        if (!(objBody instanceof ActionRequest)) {
            throw new InvalidPayloadRuntimeException(newExchange, ActionRequest.class);
        }
        ActionRequest newBody = (ActionRequest)objBody;
        if (oldExchange == null) {
            BulkRequest request = new BulkRequest();
            request.add(newBody);
            newExchange.getIn().setBody((Object)request);
            return newExchange;
        }
        BulkRequest request = (BulkRequest)oldExchange.getIn().getBody(BulkRequest.class);
        request.add(newBody);
        return oldExchange;
    }
}

