/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.elasticsearch.converter;

import java.util.List;
import java.util.Map;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.replication.ReplicationType;
import org.elasticsearch.common.xcontent.XContentBuilder;

@Converter
public final class ElasticsearchActionRequestConverter {
    private ElasticsearchActionRequestConverter() {
    }

    private static IndexRequest createIndexRequest(Object document, Exchange exchange) {
        IndexRequest indexRequest = new IndexRequest();
        if (document instanceof byte[]) {
            indexRequest.source((byte[])document);
        } else if (document instanceof Map) {
            indexRequest.source((Map)document);
        } else if (document instanceof String) {
            indexRequest.source((String)document);
        } else if (document instanceof XContentBuilder) {
            indexRequest.source((XContentBuilder)document);
        } else {
            return null;
        }
        return ((IndexRequest)((IndexRequest)((IndexRequest)indexRequest.consistencyLevel((WriteConsistencyLevel)exchange.getIn().getHeader("consistencyLevel", WriteConsistencyLevel.class))).replicationType((ReplicationType)exchange.getIn().getHeader("replicationType", ReplicationType.class))).index((String)exchange.getIn().getHeader("indexName", String.class))).type((String)exchange.getIn().getHeader("indexType", String.class));
    }

    @Converter
    public static IndexRequest toIndexRequest(Object document, Exchange exchange) {
        return ElasticsearchActionRequestConverter.createIndexRequest(document, exchange).id((String)exchange.getIn().getHeader("indexId", String.class));
    }

    @Converter
    public static GetRequest toGetRequest(String id, Exchange exchange) {
        return new GetRequest((String)exchange.getIn().getHeader("indexName", String.class)).type((String)exchange.getIn().getHeader("indexType", String.class)).id(id);
    }

    @Converter
    public static DeleteRequest toDeleteRequest(String id, Exchange exchange) {
        return ((DeleteRequest)new DeleteRequest().index((String)exchange.getIn().getHeader("indexName", String.class))).type((String)exchange.getIn().getHeader("indexType", String.class)).id(id);
    }

    @Converter
    public static SearchRequest toSearchRequest(Object queryObject, Exchange exchange) {
        Map query = (Map)exchange.getContext().getTypeConverter().convertTo(Map.class, queryObject);
        return new SearchRequest(new String[]{(String)exchange.getIn().getHeader("indexName", String.class)}).types(new String[]{(String)exchange.getIn().getHeader("indexType", String.class)}).source(query);
    }

    @Converter
    public static BulkRequest toBulkRequest(List<Object> documents, Exchange exchange) {
        BulkRequest request = new BulkRequest();
        for (Object document : documents) {
            request.add(ElasticsearchActionRequestConverter.createIndexRequest(document, exchange));
        }
        return request;
    }
}

