/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.search.builder.SearchSourceBuilder;

public class SearchRequest
extends ActionRequest<SearchRequest>
implements IndicesRequest.Replaceable {
    private SearchType searchType = SearchType.DEFAULT;
    private String[] indices;
    @Nullable
    private String routing;
    @Nullable
    private String preference;
    private BytesReference templateSource;
    private String templateName;
    private ScriptService.ScriptType templateType;
    private Map<String, Object> templateParams = Collections.emptyMap();
    private BytesReference source;
    private BytesReference extraSource;
    private Boolean queryCache;
    private Scroll scroll;
    private String[] types = Strings.EMPTY_ARRAY;
    public static final IndicesOptions DEFAULT_INDICES_OPTIONS = IndicesOptions.strictExpandOpenAndForbidClosed();
    private IndicesOptions indicesOptions = DEFAULT_INDICES_OPTIONS;

    public SearchRequest() {
    }

    public SearchRequest(SearchRequest searchRequest, ActionRequest originalRequest) {
        super(originalRequest);
        this.searchType = searchRequest.searchType;
        this.indices = searchRequest.indices;
        this.routing = searchRequest.routing;
        this.preference = searchRequest.preference;
        this.templateSource = searchRequest.templateSource;
        this.templateName = searchRequest.templateName;
        this.templateType = searchRequest.templateType;
        this.templateParams = searchRequest.templateParams;
        this.source = searchRequest.source;
        this.extraSource = searchRequest.extraSource;
        this.queryCache = searchRequest.queryCache;
        this.scroll = searchRequest.scroll;
        this.types = searchRequest.types;
        this.indicesOptions = searchRequest.indicesOptions;
    }

    public SearchRequest(ActionRequest request) {
        super(request);
    }

    public SearchRequest(String ... indices) {
        this.indices(indices);
    }

    public SearchRequest(String[] indices, byte[] source) {
        this.indices(indices);
        this.source = new BytesArray(source);
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        return validationException;
    }

    @Override
    public SearchRequest indices(String ... indices) {
        if (indices == null) {
            throw new ElasticsearchIllegalArgumentException("indices must not be null");
        }
        for (int i = 0; i < indices.length; ++i) {
            if (indices[i] != null) continue;
            throw new ElasticsearchIllegalArgumentException("indices[" + i + "] must not be null");
        }
        this.indices = indices;
        return this;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public SearchRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return this;
    }

    public String[] types() {
        return this.types;
    }

    public SearchRequest types(String ... types) {
        this.types = types;
        return this;
    }

    public String routing() {
        return this.routing;
    }

    public SearchRequest routing(String routing) {
        this.routing = routing;
        return this;
    }

    public SearchRequest routing(String ... routings) {
        this.routing = Strings.arrayToCommaDelimitedString(routings);
        return this;
    }

    public SearchRequest preference(String preference) {
        this.preference = preference;
        return this;
    }

    public String preference() {
        return this.preference;
    }

    public SearchRequest searchType(SearchType searchType) {
        this.searchType = searchType;
        return this;
    }

    public SearchRequest searchType(String searchType) throws ElasticsearchIllegalArgumentException {
        return this.searchType(SearchType.fromString(searchType));
    }

    public SearchRequest source(SearchSourceBuilder sourceBuilder) {
        this.source = sourceBuilder.buildAsBytes(Requests.CONTENT_TYPE);
        return this;
    }

    public SearchRequest source(String source) {
        this.source = new BytesArray(source);
        return this;
    }

    public SearchRequest source(Map source) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(Requests.CONTENT_TYPE);
            builder.map(source);
            return this.source(builder);
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + source + "]", e);
        }
    }

    public SearchRequest source(XContentBuilder builder) {
        this.source = builder.bytes();
        return this;
    }

    public SearchRequest source(byte[] source) {
        return this.source(source, 0, source.length);
    }

    public SearchRequest source(byte[] source, int offset, int length) {
        return this.source(new BytesArray(source, offset, length));
    }

    public SearchRequest source(BytesReference source) {
        this.source = source;
        return this;
    }

    public BytesReference source() {
        return this.source;
    }

    public BytesReference templateSource() {
        return this.templateSource;
    }

    public SearchRequest extraSource(SearchSourceBuilder sourceBuilder) {
        if (sourceBuilder == null) {
            this.extraSource = null;
            return this;
        }
        this.extraSource = sourceBuilder.buildAsBytes(Requests.CONTENT_TYPE);
        return this;
    }

    public SearchRequest extraSource(Map extraSource) {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder(Requests.CONTENT_TYPE);
            builder.map(extraSource);
            return this.extraSource(builder);
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + extraSource + "]", e);
        }
    }

    public SearchRequest extraSource(XContentBuilder builder) {
        this.extraSource = builder.bytes();
        return this;
    }

    public SearchRequest extraSource(String source) {
        this.extraSource = new BytesArray(source);
        return this;
    }

    public SearchRequest extraSource(byte[] source) {
        return this.extraSource(source, 0, source.length);
    }

    public SearchRequest extraSource(byte[] source, int offset, int length) {
        return this.extraSource(new BytesArray(source, offset, length));
    }

    public SearchRequest extraSource(BytesReference source) {
        this.extraSource = source;
        return this;
    }

    public SearchRequest templateSource(BytesReference template) {
        this.templateSource = template;
        return this;
    }

    public SearchRequest templateSource(String template) {
        this.templateSource = new BytesArray(template);
        return this;
    }

    public void templateName(String templateName) {
        this.templateName = templateName;
    }

    public void templateType(ScriptService.ScriptType templateType) {
        this.templateType = templateType;
    }

    public void templateParams(Map<String, Object> params) {
        this.templateParams = params;
    }

    public String templateName() {
        return this.templateName;
    }

    public ScriptService.ScriptType templateType() {
        return this.templateType;
    }

    public Map<String, Object> templateParams() {
        return this.templateParams;
    }

    public BytesReference extraSource() {
        return this.extraSource;
    }

    public SearchType searchType() {
        return this.searchType;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    public Scroll scroll() {
        return this.scroll;
    }

    public SearchRequest scroll(Scroll scroll) {
        this.scroll = scroll;
        return this;
    }

    public SearchRequest scroll(TimeValue keepAlive) {
        return this.scroll(new Scroll(keepAlive));
    }

    public SearchRequest scroll(String keepAlive) {
        return this.scroll(new Scroll(TimeValue.parseTimeValue(keepAlive, null)));
    }

    public SearchRequest queryCache(Boolean queryCache) {
        this.queryCache = queryCache;
        return this;
    }

    public Boolean queryCache() {
        return this.queryCache;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        if (in.getVersion().before(Version.V_1_2_0)) {
            in.readByte();
        }
        this.searchType = SearchType.fromId(in.readByte());
        this.indices = new String[in.readVInt()];
        for (int i = 0; i < this.indices.length; ++i) {
            this.indices[i] = in.readString();
        }
        this.routing = in.readOptionalString();
        this.preference = in.readOptionalString();
        if (in.readBoolean()) {
            this.scroll = Scroll.readScroll(in);
        }
        this.source = in.readBytesReference();
        this.extraSource = in.readBytesReference();
        this.types = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        if (in.getVersion().onOrAfter(Version.V_1_1_0)) {
            this.templateSource = in.readBytesReference();
            this.templateName = in.readOptionalString();
            if (in.getVersion().onOrAfter(Version.V_1_3_0)) {
                this.templateType = ScriptService.ScriptType.readFrom(in);
            }
            if (in.readBoolean()) {
                this.templateParams = (Map)in.readGenericValue();
            }
        }
        if (in.getVersion().onOrAfter(Version.V_1_4_0_Beta1)) {
            this.queryCache = in.readOptionalBoolean();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().before(Version.V_1_2_0)) {
            out.writeByte((byte)2);
        }
        out.writeByte(this.searchType.id());
        out.writeVInt(this.indices.length);
        for (String index : this.indices) {
            out.writeString(index);
        }
        out.writeOptionalString(this.routing);
        out.writeOptionalString(this.preference);
        if (this.scroll == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.scroll.writeTo(out);
        }
        out.writeBytesReference(this.source);
        out.writeBytesReference(this.extraSource);
        out.writeStringArray(this.types);
        this.indicesOptions.writeIndicesOptions(out);
        if (out.getVersion().onOrAfter(Version.V_1_1_0)) {
            out.writeBytesReference(this.templateSource);
            out.writeOptionalString(this.templateName);
            if (out.getVersion().onOrAfter(Version.V_1_3_0)) {
                ScriptService.ScriptType.writeTo(this.templateType, out);
            }
            boolean existTemplateParams = this.templateParams != null;
            out.writeBoolean(existTemplateParams);
            if (existTemplateParams) {
                out.writeGenericValue(this.templateParams);
            }
        }
        if (out.getVersion().onOrAfter(Version.V_1_4_0_Beta1)) {
            out.writeOptionalBoolean(this.queryCache);
        }
    }
}

