/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.block;

import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.rest.RestStatus;

public class ClusterBlockException
extends ElasticsearchException {
    private final ImmutableSet<ClusterBlock> blocks;

    public ClusterBlockException(ImmutableSet<ClusterBlock> blocks) {
        super(ClusterBlockException.buildMessage(blocks));
        this.blocks = blocks;
    }

    public boolean retryable() {
        for (ClusterBlock block : this.blocks) {
            if (block.retryable()) continue;
            return false;
        }
        return true;
    }

    public ImmutableSet<ClusterBlock> blocks() {
        return this.blocks;
    }

    private static String buildMessage(ImmutableSet<ClusterBlock> blocks) {
        StringBuilder sb = new StringBuilder("blocked by: ");
        for (ClusterBlock block : blocks) {
            sb.append("[").append((Object)block.status()).append("/").append(block.id()).append("/").append(block.description()).append("];");
        }
        return sb.toString();
    }

    @Override
    public RestStatus status() {
        RestStatus status = null;
        for (ClusterBlock block : this.blocks) {
            if (status == null) {
                status = block.status();
                continue;
            }
            if (status.getStatus() >= block.status().getStatus()) continue;
            status = block.status();
        }
        return status;
    }
}

