/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jackson.converter;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.Set;
import org.apache.camel.Exchange;
import org.apache.camel.FallbackConverter;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.TypeConverterRegistry;

public final class JacksonTypeConverters {
    private final ObjectMapper defaultMapper = new ObjectMapper();
    private boolean init;
    private Boolean enabled;

    @FallbackConverter
    public <T> T convertTo(Class<T> type, Exchange exchange, Object value, TypeConverterRegistry registry) {
        ObjectMapper mapper;
        if (!this.init && exchange != null) {
            String text = (String)exchange.getContext().getProperties().get("CamelJacksonEnableTypeConverter");
            this.enabled = "true".equalsIgnoreCase(text);
            this.init = true;
        }
        if (this.enabled == null || !this.enabled.booleanValue()) {
            return null;
        }
        if (JacksonTypeConverters.isNotPojoType(type)) {
            return null;
        }
        if (exchange != null && value instanceof Map && (mapper = this.resolveObjectMapper(exchange.getContext().getRegistry())).canSerialize(type)) {
            return (T)mapper.convertValue(value, type);
        }
        return null;
    }

    private static boolean isNotPojoType(Class<?> type) {
        boolean isString = String.class.isAssignableFrom(type);
        boolean isNumber = Number.class.isAssignableFrom(type) || Integer.TYPE.isAssignableFrom(type) || Long.TYPE.isAssignableFrom(type) || Short.TYPE.isAssignableFrom(type) || Character.TYPE.isAssignableFrom(type) || Float.TYPE.isAssignableFrom(type) || Double.TYPE.isAssignableFrom(type);
        return isString || isNumber;
    }

    private ObjectMapper resolveObjectMapper(Registry registry) {
        Set mappers = registry.findByType(ObjectMapper.class);
        if (mappers.size() == 1) {
            return (ObjectMapper)mappers.iterator().next();
        }
        return this.defaultMapper;
    }
}

