/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.gravia.service;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.ServerEnvironmentService;
import org.jboss.gravia.provision.spi.RuntimeEnvironment;
import org.jboss.gravia.resolver.DefaultEnvironment;
import org.jboss.gravia.resolver.Environment;
import org.jboss.gravia.resource.Capability;
import org.jboss.gravia.resource.DefaultMatchPolicy;
import org.jboss.gravia.resource.DefaultResourceBuilder;
import org.jboss.gravia.resource.MatchPolicy;
import org.jboss.gravia.resource.Requirement;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.resource.ResourceIdentity;
import org.jboss.gravia.resource.ResourceStore;
import org.jboss.gravia.resource.Version;
import org.jboss.gravia.resource.VersionRange;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.ServiceRegistration;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.AbstractService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.extension.gravia.GraviaConstants;

public class EnvironmentService
extends AbstractService<Environment> {
    private final InjectedValue<ServerEnvironment> injectedServerEnvironment = new InjectedValue();
    private final InjectedValue<Runtime> injectedRuntime = new InjectedValue();
    private ServiceRegistration<?> registration;
    private RuntimeEnvironment environment;

    public ServiceController<Environment> install(ServiceTarget serviceTarget) {
        ServiceBuilder builder = serviceTarget.addService(GraviaConstants.ENVIRONMENT_SERVICE_NAME, (Service)this);
        builder.addDependency(ServerEnvironmentService.SERVICE_NAME, ServerEnvironment.class, this.injectedServerEnvironment);
        builder.addDependency(GraviaConstants.RUNTIME_SERVICE_NAME, Runtime.class, this.injectedRuntime);
        return builder.install();
    }

    public void start(StartContext startContext) throws StartException {
        Runtime runtime = (Runtime)this.injectedRuntime.getValue();
        DefaultMatchPolicy matchPolicy = new DefaultMatchPolicy();
        File modulesDir = ((ServerEnvironment)this.injectedServerEnvironment.getValue()).getModulesDir();
        this.environment = new RuntimeEnvironment(runtime, (ResourceStore)new SystemResourceStore(modulesDir), (MatchPolicy)matchPolicy);
        ModuleContext syscontext = runtime.getModuleContext();
        this.registration = syscontext.registerService(RuntimeEnvironment.class, (Object)this.environment, null);
    }

    public void stop(StopContext context) {
        if (this.registration != null) {
            this.registration.unregister();
        }
    }

    public Environment getValue() throws IllegalStateException {
        return this.environment;
    }

    static class SystemResourceStore
    implements ResourceStore {
        private final File modulesDir;
        private final ResourceStore cachedResources = new DefaultEnvironment("SystemCache");

        SystemResourceStore(File modulesDir) {
            this.modulesDir = modulesDir;
        }

        public String getName() {
            return this.getClass().getSimpleName();
        }

        public MatchPolicy getMatchPolicy() {
            throw new UnsupportedOperationException();
        }

        public Iterator<Resource> getResources() {
            throw new UnsupportedOperationException();
        }

        public Resource addResource(Resource resource) {
            throw new UnsupportedOperationException();
        }

        public Resource removeResource(ResourceIdentity identity) {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Resource getResource(ResourceIdentity identity) {
            ResourceStore resourceStore = this.cachedResources;
            synchronized (resourceStore) {
                Resource resource = this.cachedResources.getResource(identity);
                if (resource == null) {
                    String symbolicName = identity.getSymbolicName();
                    Version version = identity.getVersion();
                    String modname = symbolicName + (version != Version.emptyVersion ? ":" + version : "");
                    ModuleIdentifier modid = ModuleIdentifier.fromString((String)modname);
                    ModuleLoader moduleLoader = Module.getBootModuleLoader();
                    try {
                        moduleLoader.loadModule(modid);
                    }
                    catch (ModuleLoadException ex) {
                        return null;
                    }
                    DefaultResourceBuilder builder = new DefaultResourceBuilder();
                    Capability icap = builder.addIdentityCapability(symbolicName, version);
                    icap.getAttributes().put("type", "abstract");
                    icap.getAttributes().put(ModuleIdentifier.class.getName(), modid);
                    resource = this.cachedResources.addResource(builder.getResource());
                }
                return resource;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<Capability> findProviders(Requirement requirement) {
            ResourceStore resourceStore = this.cachedResources;
            synchronized (resourceStore) {
                HashSet<Capability> result = this.cachedResources.findProviders(requirement);
                if (!result.isEmpty()) {
                    return result;
                }
                ModuleLoader moduleLoader = Module.getBootModuleLoader();
                result = new HashSet<Capability>();
                String symbolicName = (String)requirement.getAttribute("gravia.identity");
                VersionRange versionRange = (VersionRange)requirement.getAttribute("version");
                File moduleDir = new File(this.modulesDir, symbolicName.replace(".", File.separator));
                if (versionRange != null && moduleDir.isDirectory()) {
                    for (File file : moduleDir.listFiles()) {
                        Version version;
                        if (!file.isDirectory() || file.getName().equals("main")) continue;
                        try {
                            version = new Version(file.getName());
                        }
                        catch (Throwable th) {
                            continue;
                        }
                        if (!versionRange.includes(version)) continue;
                        String modname = symbolicName + ":" + version;
                        ModuleIdentifier modid = ModuleIdentifier.fromString((String)modname);
                        try {
                            moduleLoader.loadModule(modid);
                        }
                        catch (ModuleLoadException ex) {
                            continue;
                        }
                        DefaultResourceBuilder builder = new DefaultResourceBuilder();
                        Capability icap = builder.addIdentityCapability(symbolicName, version);
                        icap.getAttributes().put("type", "abstract");
                        icap.getAttributes().put(ModuleIdentifier.class.getName(), modid);
                        Resource resource = this.cachedResources.addResource(builder.getResource());
                        result.add(resource.getIdentityCapability());
                    }
                }
                if (result.isEmpty()) {
                    ModuleIdentifier modid = ModuleIdentifier.fromString((String)symbolicName);
                    try {
                        moduleLoader.loadModule(modid);
                        DefaultResourceBuilder builder = new DefaultResourceBuilder();
                        Capability icap = builder.addIdentityCapability(symbolicName, Version.emptyVersion);
                        icap.getAttributes().put("type", "abstract");
                        icap.getAttributes().put(ModuleIdentifier.class.getName(), modid);
                        Resource resource = this.cachedResources.addResource(builder.getResource());
                        result.add(resource.getIdentityCapability());
                    }
                    catch (ModuleLoadException ex) {
                        // empty catch block
                    }
                }
                return Collections.unmodifiableSet(result);
            }
        }
    }
}

