/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http4;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.component.http4.HttpClientConfigurer;
import org.apache.http.impl.client.HttpClientBuilder;

public class CompositeHttpConfigurer
implements HttpClientConfigurer {
    private final List<HttpClientConfigurer> configurers = new ArrayList<HttpClientConfigurer>();

    public void addConfigurer(HttpClientConfigurer configurer) {
        if (configurer != null) {
            this.configurers.add(configurer);
        }
    }

    public void removeConfigurer(HttpClientConfigurer configurer) {
        this.configurers.remove(configurer);
    }

    @Override
    public void configureHttpClient(HttpClientBuilder clientBuilder) {
        for (HttpClientConfigurer configurer : this.configurers) {
            configurer.configureHttpClient(clientBuilder);
        }
    }

    public static CompositeHttpConfigurer combineConfigurers(HttpClientConfigurer oldConfigurer, HttpClientConfigurer newConfigurer) {
        if (oldConfigurer instanceof CompositeHttpConfigurer) {
            ((CompositeHttpConfigurer)oldConfigurer).addConfigurer(newConfigurer);
            return (CompositeHttpConfigurer)oldConfigurer;
        }
        CompositeHttpConfigurer answer = new CompositeHttpConfigurer();
        answer.addConfigurer(newConfigurer);
        answer.addConfigurer(oldConfigurer);
        return answer;
    }
}

