/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mqtt;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.fusesource.mqtt.client.MQTT;
import org.fusesource.mqtt.client.QoS;

@UriParams
public class MQTTConfiguration
extends MQTT {
    public static final String MQTT_SUBSCRIBE_TOPIC = "CamelMQTTSubscribeTopic";
    public static final String MQTT_PUBLISH_TOPIC = "CamelMQTTPublishTopic";
    @UriParam(defaultValue="tcp://127.0.0.1:1883")
    URI host;
    @UriParam
    URI localAddress;
    @UriParam
    SSLContext sslContext;
    @UriParam
    DispatchQueue dispatchQueue;
    @UriParam
    Executor blockingExecutor;
    @UriParam
    int maxReadRate;
    @UriParam
    int maxWriteRate;
    @UriParam(defaultValue="8")
    int trafficClass = 8;
    @UriParam(defaultValue="65536")
    int receiveBufferSize = 65536;
    @UriParam(defaultValue="65536")
    int sendBufferSize = 65536;
    @UriParam(defaultValue="10")
    long reconnectDelay = 10L;
    @UriParam(defaultValue="30000")
    long reconnectDelayMax = 30000L;
    @UriParam(defaultValue="2.0")
    double reconnectBackOffMultiplier = 2.0;
    @UriParam(defaultValue="-1")
    long reconnectAttemptsMax = -1L;
    @UriParam(defaultValue="-1")
    long connectAttemptsMax = -1L;
    @UriParam
    String clientId;
    @UriParam
    boolean cleanSession;
    @UriParam
    short keepAlive;
    @UriParam
    String willTopic;
    @UriParam
    String willMessage;
    @UriParam(defaultValue="AT_MOST_ONCE")
    QoS willQos = QoS.AT_MOST_ONCE;
    @UriParam
    QoS willRetain;
    @UriParam(defaultValue="3.1")
    String version;
    @UriParam(defaultValue="MQTTTopicPropertyName")
    private String mqttTopicPropertyName = "MQTTTopicPropertyName";
    @UriParam(defaultValue="MQTTRetain")
    private String mqttRetainPropertyName = "MQTTRetain";
    @UriParam(defaultValue="MQTTQos")
    private String mqttQosPropertyName = "MQTTQos";
    @UriParam
    @Deprecated
    private String subscribeTopicName = "";
    @UriParam
    private String subscribeTopicNames = "";
    @UriParam(defaultValue="camel/mqtt/test")
    private String publishTopicName = "camel/mqtt/test";
    @UriParam(defaultValue="10")
    private int connectWaitInSeconds = 10;
    @UriParam(defaultValue="5")
    private int disconnectWaitInSeconds = 5;
    @UriParam(defaultValue="5")
    private int sendWaitInSeconds = 5;
    @UriParam
    private boolean byDefaultRetain;
    @UriParam(enums="AT_MOST_ONCE,AT_LEAST_ONCE,EXACTLY_ONCE", defaultValue="AT_LEAST_ONCE")
    private String qualityOfService = QoS.AT_LEAST_ONCE.name();
    private QoS qos = QoS.AT_LEAST_ONCE;

    public String getQualityOfService() {
        return this.qualityOfService;
    }

    public void setQualityOfService(String qualityOfService) {
        this.qos = MQTTConfiguration.getQoS(qualityOfService);
        this.qualityOfService = qualityOfService;
    }

    public QoS getQoS() {
        return this.qos;
    }

    @Deprecated
    public String getSubscribeTopicName() {
        return this.subscribeTopicName;
    }

    @Deprecated
    public void setSubscribeTopicName(String subscribeTopicName) {
        this.subscribeTopicName = subscribeTopicName;
    }

    public String getSubscribeTopicNames() {
        return this.subscribeTopicNames;
    }

    public void setSubscribeTopicNames(String subscribeTopicNames) {
        this.subscribeTopicNames = subscribeTopicNames;
    }

    public String getPublishTopicName() {
        return this.publishTopicName;
    }

    public void setPublishTopicName(String publishTopicName) {
        this.publishTopicName = publishTopicName;
    }

    @Deprecated
    public String getMqttTopicPropertyName() {
        return this.mqttTopicPropertyName;
    }

    @Deprecated
    public void setMqttTopicPropertyName(String mqttTopicPropertyName) {
        this.mqttTopicPropertyName = mqttTopicPropertyName;
    }

    public String getMqttRetainPropertyName() {
        return this.mqttRetainPropertyName;
    }

    public void setMqttRetainPropertyName(String mqttRetainPropertyName) {
        this.mqttRetainPropertyName = mqttRetainPropertyName;
    }

    public String getMqttQosPropertyName() {
        return this.mqttQosPropertyName;
    }

    public void setMqttQosPropertyName(String mqttQosPropertyName) {
        this.mqttQosPropertyName = mqttQosPropertyName;
    }

    public int getConnectWaitInSeconds() {
        return this.connectWaitInSeconds;
    }

    public void setConnectWaitInSeconds(int connectWaitInSeconds) {
        this.connectWaitInSeconds = connectWaitInSeconds;
    }

    public int getDisconnectWaitInSeconds() {
        return this.disconnectWaitInSeconds;
    }

    public void setDisconnectWaitInSeconds(int disconnectWaitInSeconds) {
        this.disconnectWaitInSeconds = disconnectWaitInSeconds;
    }

    public int getSendWaitInSeconds() {
        return this.sendWaitInSeconds;
    }

    public void setSendWaitInSeconds(int sendWaitInSeconds) {
        this.sendWaitInSeconds = sendWaitInSeconds;
    }

    public boolean isByDefaultRetain() {
        return this.byDefaultRetain;
    }

    public void setByDefaultRetain(boolean byDefaultRetain) {
        this.byDefaultRetain = byDefaultRetain;
    }

    static QoS getQoS(String qualityOfService) {
        for (QoS q : QoS.values()) {
            if (!q.name().equalsIgnoreCase(qualityOfService)) continue;
            return q;
        }
        if (qualityOfService.equalsIgnoreCase("ATMOSTONCE")) {
            return QoS.AT_MOST_ONCE;
        }
        if (qualityOfService.equalsIgnoreCase("EXACTLYONCE")) {
            return QoS.EXACTLY_ONCE;
        }
        if (qualityOfService.equalsIgnoreCase("ATLEASTONCE")) {
            return QoS.AT_LEAST_ONCE;
        }
        throw new IllegalArgumentException("There is no QoS with name " + qualityOfService);
    }

    public void setClientId(String clientId) {
        super.setClientId(clientId);
    }

    public void setCleanSession(boolean cleanSession) {
        super.setCleanSession(cleanSession);
    }

    public void setKeepAlive(short keepAlive) {
        super.setKeepAlive(keepAlive);
    }

    public void setPassword(String password) {
        super.setPassword(password);
    }

    public void setUserName(String userName) {
        super.setUserName(userName);
    }

    public void setWillMessage(String willMessage) {
        super.setWillMessage(willMessage);
    }

    public void setWillQos(QoS willQos) {
        super.setWillQos(willQos);
    }

    public void setVersion(String version) {
        super.setVersion(version);
    }

    public String getVersion() {
        return super.getVersion();
    }

    public void setWillRetain(boolean willRetain) {
        super.setWillRetain(willRetain);
    }

    public void setWillTopic(String willTopic) {
        super.setWillTopic(willTopic);
    }

    public Executor getBlockingExecutor() {
        return super.getBlockingExecutor();
    }

    public void setBlockingExecutor(Executor blockingExecutor) {
        super.setBlockingExecutor(blockingExecutor);
    }

    public DispatchQueue getDispatchQueue() {
        return super.getDispatchQueue();
    }

    public void setDispatchQueue(DispatchQueue dispatchQueue) {
        super.setDispatchQueue(dispatchQueue);
    }

    public URI getLocalAddress() {
        return super.getLocalAddress();
    }

    public void setLocalAddress(String localAddress) throws URISyntaxException {
        super.setLocalAddress(localAddress);
    }

    public void setLocalAddress(URI localAddress) {
        super.setLocalAddress(localAddress);
    }

    public int getMaxReadRate() {
        return super.getMaxReadRate();
    }

    public void setMaxReadRate(int maxReadRate) {
        super.setMaxReadRate(maxReadRate);
    }

    public int getMaxWriteRate() {
        return super.getMaxWriteRate();
    }

    public void setMaxWriteRate(int maxWriteRate) {
        super.setMaxWriteRate(maxWriteRate);
    }

    public int getReceiveBufferSize() {
        return super.getReceiveBufferSize();
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        super.setReceiveBufferSize(receiveBufferSize);
    }

    public URI getHost() {
        return super.getHost();
    }

    public void setHost(String host) throws URISyntaxException {
        super.setHost(host);
    }

    public void setHost(URI host) {
        super.setHost(host);
    }

    public int getSendBufferSize() {
        return super.getSendBufferSize();
    }

    public void setSendBufferSize(int sendBufferSize) {
        super.setSendBufferSize(sendBufferSize);
    }

    public SSLContext getSslContext() {
        return super.getSslContext();
    }

    public void setSslContext(SSLContext sslContext) {
        super.setSslContext(sslContext);
    }

    public int getTrafficClass() {
        return super.getTrafficClass();
    }

    public void setTrafficClass(int trafficClass) {
        super.setTrafficClass(trafficClass);
    }

    public long getConnectAttemptsMax() {
        return super.getConnectAttemptsMax();
    }

    public void setConnectAttemptsMax(long connectAttemptsMax) {
        super.setConnectAttemptsMax(connectAttemptsMax);
    }

    public long getReconnectAttemptsMax() {
        return super.getReconnectAttemptsMax();
    }

    public void setReconnectAttemptsMax(long reconnectAttemptsMax) {
        super.setReconnectAttemptsMax(reconnectAttemptsMax);
    }

    public double getReconnectBackOffMultiplier() {
        return super.getReconnectBackOffMultiplier();
    }

    public void setReconnectBackOffMultiplier(double reconnectBackOffMultiplier) {
        super.setReconnectBackOffMultiplier(reconnectBackOffMultiplier);
    }

    public long getReconnectDelay() {
        return super.getReconnectDelay();
    }

    public void setReconnectDelay(long reconnectDelay) {
        super.setReconnectDelay(reconnectDelay);
    }

    public long getReconnectDelayMax() {
        return super.getReconnectDelayMax();
    }

    public void setReconnectDelayMax(long reconnectDelayMax) {
        super.setReconnectDelayMax(reconnectDelayMax);
    }
}

