/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.java.proxies;

import java.lang.reflect.Array;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.java.proxies.ArrayJavaProxy;
import org.jruby.javasupport.Java;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ArrayJavaProxyCreator
extends RubyObject {
    private static final int[] EMPTY = new int[0];
    Class elementClass;
    int[] dimensions = EMPTY;

    public static RubyClass createArrayJavaProxyCreator(ThreadContext context) {
        Ruby runtime = context.runtime;
        RubyClass arrayJavaProxyCreator = runtime.defineClass("ArrayJavaProxyCreator", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        arrayJavaProxyCreator.defineAnnotatedMethods(ArrayJavaProxyCreator.class);
        return arrayJavaProxyCreator;
    }

    public ArrayJavaProxyCreator(Ruby runtime) {
        super(runtime, runtime.getJavaSupport().getArrayJavaProxyCreatorClass());
    }

    public void setup(ThreadContext context, IRubyObject javaClass, IRubyObject[] sizes) {
        this.elementClass = (Class)javaClass.toJava(Class.class);
        this.aggregateDimensions(sizes);
    }

    @JRubyMethod(required=1, rest=true)
    public IRubyObject op_aref(ThreadContext context, IRubyObject[] sizes) {
        Arity.checkArgumentCount(context.runtime, sizes, 1, -1);
        this.aggregateDimensions(sizes);
        return this;
    }

    @JRubyMethod(name={"new"})
    public IRubyObject _new(ThreadContext context) {
        Ruby runtime = context.runtime;
        Object array = Array.newInstance(this.elementClass, this.dimensions);
        return new ArrayJavaProxy(runtime, Java.getProxyClassForObject(runtime, array), array);
    }

    private void aggregateDimensions(IRubyObject[] sizes) {
        int[] newDimensions = new int[this.dimensions.length + sizes.length];
        System.arraycopy(this.dimensions, 0, newDimensions, 0, this.dimensions.length);
        for (int i2 = 0; i2 < sizes.length; ++i2) {
            int intSize;
            IRubyObject size2 = sizes[i2];
            newDimensions[i2 + this.dimensions.length] = intSize = (int)size2.convertToInteger().getLongValue();
        }
        this.dimensions = newDimensions;
    }
}

