/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.component;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.component.undertow.UndertowComponent;
import org.apache.camel.component.undertow.UndertowConsumer;
import org.apache.camel.component.undertow.UndertowEndpoint;
import org.apache.camel.component.undertow.UndertowHost;
import org.jboss.gravia.runtime.ServiceLocator;
import org.wildfly.extension.camel.CamelLogger;

public class WildflyUndertowComponent
extends UndertowComponent {
    protected UndertowEndpoint createEndpointInstance(URI endpointUri, UndertowComponent component) throws URISyntaxException {
        return new WildflyUndertowEndpoint(endpointUri.toString(), component);
    }

    public void startServer(UndertowConsumer consumer) {
    }

    class WildflyUndertowUndertowConsumer
    extends UndertowConsumer {
        WildflyUndertowUndertowConsumer(UndertowEndpoint endpoint, Processor processor) throws Exception {
            super(endpoint, processor);
            URI uri = new URI(endpoint.getEndpointUri());
            String host = uri.getHost();
            int port = uri.getPort();
            if (!"localhost".equals(host) || port > 0) {
                CamelLogger.LOGGER.warn("Ignoring configured host/port: {}", (Object)uri);
            }
        }

        protected UndertowHost createUndertowHost() {
            return (UndertowHost)ServiceLocator.getRequiredService(UndertowHost.class);
        }
    }

    class WildflyUndertowEndpoint
    extends UndertowEndpoint {
        WildflyUndertowEndpoint(String uri, UndertowComponent component) throws URISyntaxException {
            super(uri, component);
        }

        public Consumer createConsumer(Processor processor) throws Exception {
            return new WildflyUndertowUndertowConsumer(this, processor);
        }
    }
}

