/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.geo;

import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.Filter;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.lucene.search.XBooleanFilter;
import org.elasticsearch.index.mapper.geo.GeoPointFieldMapper;

public class IndexedGeoBoundingBoxFilter {
    public static Filter create(GeoPoint topLeft, GeoPoint bottomRight, GeoPointFieldMapper fieldMapper) {
        if (!fieldMapper.isEnableLatLon()) {
            throw new ElasticsearchIllegalArgumentException("lat/lon is not enabled (indexed) for field [" + fieldMapper.name() + "], can't use indexed filter on it");
        }
        if (topLeft.lon() > bottomRight.lon()) {
            return IndexedGeoBoundingBoxFilter.westGeoBoundingBoxFilter(topLeft, bottomRight, fieldMapper);
        }
        return IndexedGeoBoundingBoxFilter.eastGeoBoundingBoxFilter(topLeft, bottomRight, fieldMapper);
    }

    private static Filter westGeoBoundingBoxFilter(GeoPoint topLeft, GeoPoint bottomRight, GeoPointFieldMapper fieldMapper) {
        XBooleanFilter filter = new XBooleanFilter();
        filter.add(fieldMapper.lonMapper().rangeFilter(null, bottomRight.lon(), true, true), BooleanClause.Occur.SHOULD);
        filter.add(fieldMapper.lonMapper().rangeFilter(topLeft.lon(), null, true, true), BooleanClause.Occur.SHOULD);
        filter.add(fieldMapper.latMapper().rangeFilter(bottomRight.lat(), topLeft.lat(), true, true), BooleanClause.Occur.MUST);
        return filter;
    }

    private static Filter eastGeoBoundingBoxFilter(GeoPoint topLeft, GeoPoint bottomRight, GeoPointFieldMapper fieldMapper) {
        XBooleanFilter filter = new XBooleanFilter();
        filter.add(fieldMapper.lonMapper().rangeFilter(topLeft.lon(), bottomRight.lon(), true, true), BooleanClause.Occur.MUST);
        filter.add(fieldMapper.latMapper().rangeFilter(bottomRight.lat(), topLeft.lat(), true, true), BooleanClause.Occur.MUST);
        return filter;
    }
}

