/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.swagger;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.spi.RestApiProcessorFactory;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.swagger.RestSwaggerProcessor;

public class SwaggerRestApiProcessorFactory
implements RestApiProcessorFactory {
    public Processor createApiProcessor(CamelContext camelContext, String contextPath, String contextIdPattern, boolean contextIdListing, RestConfiguration configuration, Map<String, Object> parameters) throws Exception {
        String host;
        HashMap<String, Object> options = new HashMap<String, Object>(parameters);
        if (configuration.getApiProperties() != null) {
            options.putAll(configuration.getApiProperties());
        }
        if ((host = (String)options.get("host")) == null) {
            host = configuration.getHost();
            int port = configuration.getPort();
            if (host != null && port > 0) {
                options.put("host", host + ":" + port);
            } else if (host != null) {
                options.put("host", host);
            } else {
                options.put("host", "localhost");
            }
        }
        String path = configuration.getContextPath();
        options.put("base.path", path);
        return new RestSwaggerProcessor(contextIdPattern, contextIdListing, options);
    }
}

