/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.bindy;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.Locale;
import org.apache.camel.dataformat.bindy.Format;
import org.apache.camel.dataformat.bindy.annotation.DataField;
import org.apache.camel.dataformat.bindy.annotation.KeyValuePairField;
import org.apache.camel.dataformat.bindy.format.BigDecimalFormat;
import org.apache.camel.dataformat.bindy.format.BigDecimalPatternFormat;
import org.apache.camel.dataformat.bindy.format.BigIntegerFormat;
import org.apache.camel.dataformat.bindy.format.BooleanFormat;
import org.apache.camel.dataformat.bindy.format.ByteFormat;
import org.apache.camel.dataformat.bindy.format.BytePatternFormat;
import org.apache.camel.dataformat.bindy.format.CharacterFormat;
import org.apache.camel.dataformat.bindy.format.DatePatternFormat;
import org.apache.camel.dataformat.bindy.format.DoubleFormat;
import org.apache.camel.dataformat.bindy.format.DoublePatternFormat;
import org.apache.camel.dataformat.bindy.format.EnumFormat;
import org.apache.camel.dataformat.bindy.format.FloatFormat;
import org.apache.camel.dataformat.bindy.format.FloatPatternFormat;
import org.apache.camel.dataformat.bindy.format.IntegerFormat;
import org.apache.camel.dataformat.bindy.format.IntegerPatternFormat;
import org.apache.camel.dataformat.bindy.format.LongFormat;
import org.apache.camel.dataformat.bindy.format.LongPatternFormat;
import org.apache.camel.dataformat.bindy.format.ShortFormat;
import org.apache.camel.dataformat.bindy.format.ShortPatternFormat;
import org.apache.camel.dataformat.bindy.format.StringFormat;
import org.apache.camel.util.ObjectHelper;

public final class FormatFactory {
    private FormatFactory() {
    }

    private static Format<?> doGetFormat(Class<?> clazz, String pattern, String locale, String timezone, int precision, String rounding, boolean impliedDecimalSeparator, String decimalSeparator, String groupingSeparator) throws Exception {
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return ObjectHelper.isNotEmpty((Object)pattern) ? new BytePatternFormat(pattern, FormatFactory.getLocale(locale)) : new ByteFormat();
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return ObjectHelper.isNotEmpty((Object)pattern) ? new ShortPatternFormat(pattern, FormatFactory.getLocale(locale)) : new ShortFormat();
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return ObjectHelper.isNotEmpty((Object)pattern) ? new IntegerPatternFormat(pattern, FormatFactory.getLocale(locale)) : new IntegerFormat();
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return ObjectHelper.isNotEmpty((Object)pattern) ? new LongPatternFormat(pattern, FormatFactory.getLocale(locale)) : new LongFormat();
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return ObjectHelper.isNotEmpty((Object)pattern) ? new FloatPatternFormat(pattern, FormatFactory.getLocale(locale)) : new FloatFormat(impliedDecimalSeparator, precision, FormatFactory.getLocale(locale));
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return ObjectHelper.isNotEmpty((Object)pattern) ? new DoublePatternFormat(pattern, FormatFactory.getLocale(locale)) : new DoubleFormat(impliedDecimalSeparator, precision, FormatFactory.getLocale(locale));
        }
        if (clazz == BigDecimal.class) {
            return ObjectHelper.isNotEmpty((Object)pattern) ? new BigDecimalPatternFormat(pattern, FormatFactory.getLocale(locale), precision, rounding, decimalSeparator, groupingSeparator) : new BigDecimalFormat(impliedDecimalSeparator, precision, FormatFactory.getLocale(locale));
        }
        if (clazz == BigInteger.class) {
            return new BigIntegerFormat();
        }
        if (clazz == String.class) {
            return new StringFormat();
        }
        if (clazz == Date.class) {
            return new DatePatternFormat(pattern, timezone, FormatFactory.getLocale(locale));
        }
        if (clazz == Character.TYPE || clazz == Character.class) {
            return new CharacterFormat();
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return new BooleanFormat();
        }
        if (clazz.isEnum()) {
            EnumFormat fmt = new EnumFormat(clazz);
            return fmt;
        }
        throw new IllegalArgumentException("Can not find a suitable formatter for the type: " + clazz.getCanonicalName());
    }

    public static Format<?> getFormat(Class<?> clazz, String locale, DataField data) throws Exception {
        String pattern = data.pattern();
        String timezone = data.timezone();
        int precision = data.precision();
        String decimalSeparator = data.decimalSeparator();
        String groupingSeparator = data.groupingSeparator();
        String rounding = data.rounding();
        return FormatFactory.doGetFormat(clazz, pattern, locale, timezone, precision, rounding, data.impliedDecimalSeparator(), decimalSeparator, groupingSeparator);
    }

    public static Format<?> getFormat(Class<?> clazz, String locale, KeyValuePairField data) throws Exception {
        String pattern = data.pattern();
        String timezone = data.timezone();
        int precision = data.precision();
        return FormatFactory.doGetFormat(clazz, pattern, locale, timezone, precision, null, data.impliedDecimalSeparator(), null, null);
    }

    private static Locale getLocale(String locale) {
        String[] result;
        if ("default".equals(locale)) {
            return Locale.getDefault();
        }
        Locale answer = null;
        if (ObjectHelper.isNotEmpty((Object)locale) && (result = locale.split("-")).length <= 2) {
            answer = result.length == 1 ? new Locale(result[0]) : new Locale(result[0], result[1]);
        }
        return answer;
    }
}

