/*
 * Decompiled with CFR 0.152.
 */
package com.spatial4j.core.shape.impl;

import com.spatial4j.core.context.SpatialContext;
import com.spatial4j.core.distance.DistanceUtils;
import com.spatial4j.core.shape.Point;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.Shape;
import com.spatial4j.core.shape.SpatialRelation;
import com.spatial4j.core.shape.impl.InfBufLine;
import com.spatial4j.core.shape.impl.PointImpl;

public class BufferedLine
implements Shape {
    private final Point pA;
    private final Point pB;
    private final double buf;
    private final Rectangle bbox;
    private final InfBufLine linePrimary;
    private final InfBufLine linePerp;

    public BufferedLine(Point pA, Point pB, double buf, SpatialContext ctx) {
        double maxX;
        double minX;
        double maxY;
        double minY;
        assert (buf >= 0.0);
        boolean bufExtend = true;
        this.pA = pA;
        this.pB = pB;
        this.buf = buf;
        double deltaY = pB.getY() - pA.getY();
        double deltaX = pB.getX() - pA.getX();
        PointImpl center = new PointImpl(pA.getX() + deltaX / 2.0, pA.getY() + deltaY / 2.0, null);
        double perpExtent = buf;
        if (deltaX == 0.0 && deltaY == 0.0) {
            this.linePrimary = new InfBufLine(0.0, center, buf);
            this.linePerp = new InfBufLine(Double.POSITIVE_INFINITY, center, buf);
        } else {
            this.linePrimary = new InfBufLine(deltaY / deltaX, center, buf);
            double length = Math.sqrt(deltaX * deltaX + deltaY * deltaY);
            this.linePerp = new InfBufLine(-deltaX / deltaY, center, length / 2.0 + perpExtent);
        }
        if (deltaX == 0.0) {
            if (pA.getY() <= pB.getY()) {
                minY = pA.getY();
                maxY = pB.getY();
            } else {
                minY = pB.getY();
                maxY = pA.getY();
            }
            minX = pA.getX() - buf;
            maxX = pA.getX() + buf;
            minY -= perpExtent;
            maxY += perpExtent;
        } else {
            double bboxBuf = buf * (1.0 + Math.abs(this.linePrimary.getSlope())) * this.linePrimary.getDistDenomInv();
            assert (bboxBuf >= buf && bboxBuf <= buf * 1.5);
            if (pA.getX() <= pB.getX()) {
                minX = pA.getX() - bboxBuf;
                maxX = pB.getX() + bboxBuf;
            } else {
                minX = pB.getX() - bboxBuf;
                maxX = pA.getX() + bboxBuf;
            }
            if (pA.getY() <= pB.getY()) {
                minY = pA.getY() - bboxBuf;
                maxY = pB.getY() + bboxBuf;
            } else {
                minY = pB.getY() - bboxBuf;
                maxY = pA.getY() + bboxBuf;
            }
        }
        Rectangle bounds = ctx.getWorldBounds();
        this.bbox = ctx.makeRectangle(Math.max(bounds.getMinX(), minX), Math.min(bounds.getMaxX(), maxX), Math.max(bounds.getMinY(), minY), Math.min(bounds.getMaxY(), maxY));
    }

    @Override
    public boolean isEmpty() {
        return this.pA.isEmpty();
    }

    @Override
    public Shape getBuffered(double distance, SpatialContext ctx) {
        return new BufferedLine(this.pA, this.pB, this.buf + distance, ctx);
    }

    public static double expandBufForLongitudeSkew(Point pA, Point pB, double buf) {
        double absA = Math.abs(pA.getY());
        double absB = Math.abs(pB.getY());
        double maxLat = Math.max(absA, absB);
        double newBuf = DistanceUtils.calcLonDegreesAtLat(maxLat, buf);
        assert (newBuf >= buf);
        return newBuf;
    }

    @Override
    public SpatialRelation relate(Shape other) {
        if (other instanceof Point) {
            return this.contains((Point)other) ? SpatialRelation.CONTAINS : SpatialRelation.DISJOINT;
        }
        if (other instanceof Rectangle) {
            return this.relate((Rectangle)other);
        }
        throw new UnsupportedOperationException();
    }

    public SpatialRelation relate(Rectangle r) {
        SpatialRelation bboxR = this.bbox.relate(r);
        if (bboxR == SpatialRelation.DISJOINT || bboxR == SpatialRelation.WITHIN) {
            return bboxR;
        }
        PointImpl scratch = new PointImpl(0.0, 0.0, null);
        Point prC = r.getCenter();
        SpatialRelation result = this.linePrimary.relate(r, prC, scratch);
        if (result == SpatialRelation.DISJOINT) {
            return SpatialRelation.DISJOINT;
        }
        SpatialRelation resultOpp = this.linePerp.relate(r, prC, scratch);
        if (resultOpp == SpatialRelation.DISJOINT) {
            return SpatialRelation.DISJOINT;
        }
        if (result == resultOpp) {
            return result;
        }
        return SpatialRelation.INTERSECTS;
    }

    public boolean contains(Point p) {
        return this.linePrimary.contains(p) && this.linePerp.contains(p);
    }

    @Override
    public Rectangle getBoundingBox() {
        return this.bbox;
    }

    @Override
    public boolean hasArea() {
        return this.buf > 0.0;
    }

    @Override
    public double getArea(SpatialContext ctx) {
        return this.linePrimary.getBuf() * this.linePerp.getBuf() * 4.0;
    }

    @Override
    public Point getCenter() {
        return this.getBoundingBox().getCenter();
    }

    public Point getA() {
        return this.pA;
    }

    public Point getB() {
        return this.pB;
    }

    public double getBuf() {
        return this.buf;
    }

    public InfBufLine getLinePrimary() {
        return this.linePrimary;
    }

    public InfBufLine getLinePerp() {
        return this.linePerp;
    }

    public String toString() {
        return "BufferedLine(" + this.pA + ", " + this.pB + " b=" + this.buf + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BufferedLine that = (BufferedLine)o;
        if (Double.compare(that.buf, this.buf) != 0) {
            return false;
        }
        if (!this.pA.equals(that.pA)) {
            return false;
        }
        return this.pB.equals(that.pB);
    }

    public int hashCode() {
        int result = this.pA.hashCode();
        result = 31 * result + this.pB.hashCode();
        long temp = this.buf != 0.0 ? Double.doubleToLongBits(this.buf) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

