/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.zookeeper.policy;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.zookeeper.SequenceComparator;
import org.apache.camel.component.zookeeper.ZooKeeperEndpoint;
import org.apache.camel.component.zookeeper.policy.ElectionWatcher;
import org.apache.camel.impl.JavaUuidGenerator;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.UuidGenerator;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooKeeperElection {
    private static final Logger LOG = LoggerFactory.getLogger(ZooKeeperElection.class);
    private final ProducerTemplate producerTemplate;
    private final CamelContext camelContext;
    private final String uri;
    private final String candidateName;
    private final Lock lock = new ReentrantLock();
    private final CountDownLatch electionComplete = new CountDownLatch(1);
    private AtomicBoolean masterNode = new AtomicBoolean();
    private volatile boolean isCandidateCreated;
    private int enabledCount = 1;
    private UuidGenerator uuidGenerator = new JavaUuidGenerator();
    private final List<ElectionWatcher> watchers = new ArrayList<ElectionWatcher>();

    public ZooKeeperElection(CamelContext camelContext, String uri, int enabledCount) {
        this(camelContext.createProducerTemplate(), camelContext, uri, enabledCount);
    }

    public ZooKeeperElection(ProducerTemplate producerTemplate, CamelContext camelContext, String uri, int enabledCount) {
        this.camelContext = camelContext;
        this.producerTemplate = producerTemplate;
        this.uri = uri;
        this.enabledCount = enabledCount;
        this.candidateName = this.createCandidateName();
    }

    public boolean isMaster() {
        if (!this.isCandidateCreated) {
            this.testAndCreateCandidateNode();
            this.awaitElectionResults();
        }
        return this.masterNode.get();
    }

    private String createCandidateName() {
        StringBuilder builder = new StringBuilder();
        try {
            builder.append(InetAddress.getLocalHost().getCanonicalHostName());
        }
        catch (UnknownHostException ex) {
            LOG.warn("Failed to get the local hostname.", (Throwable)ex);
            builder.append("unknown-host");
        }
        builder.append("-").append(this.uuidGenerator.generateUuid());
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testAndCreateCandidateNode() {
        try {
            this.lock.lock();
            if (!this.isCandidateCreated) {
                this.createCandidateNode(this.camelContext);
                this.isCandidateCreated = true;
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void awaitElectionResults() {
        while (this.electionComplete.getCount() > 0L) {
            try {
                LOG.debug("Awaiting election results...");
                this.electionComplete.await();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private ZooKeeperEndpoint createCandidateNode(CamelContext camelContext) {
        LOG.info("Initializing ZookeeperElection with uri '{}'", (Object)this.uri);
        ZooKeeperEndpoint zep = (ZooKeeperEndpoint)camelContext.getEndpoint(this.uri, ZooKeeperEndpoint.class);
        zep.getConfiguration().setCreate(true);
        String fullpath = this.createFullPathToCandidate(zep);
        Exchange e = zep.createExchange();
        e.setPattern(ExchangePattern.InOut);
        e.getIn().setHeader("CamelZooKeeperNode", (Object)fullpath);
        e.getIn().setHeader("CamelZookeeperCreateMode", (Object)CreateMode.EPHEMERAL_SEQUENTIAL);
        this.producerTemplate.send((Endpoint)zep, e);
        if (e.isFailed()) {
            LOG.error("Error setting up election node " + fullpath, (Throwable)e.getException());
        } else {
            LOG.info("Candidate node '{}' has been created", (Object)fullpath);
            try {
                if (zep != null) {
                    camelContext.addRoutes((RoutesBuilder)new ElectoralMonitorRoute(zep));
                }
            }
            catch (Exception ex) {
                LOG.error("Error configuring ZookeeperElection", (Throwable)ex);
            }
        }
        return zep;
    }

    private String createFullPathToCandidate(ZooKeeperEndpoint zep) {
        String fullpath = zep.getConfiguration().getPath();
        if (!fullpath.endsWith("/")) {
            fullpath = fullpath + "/";
        }
        fullpath = fullpath + this.candidateName;
        return fullpath;
    }

    private void handleException(Exception e) {
        throw new RuntimeException(e.getMessage(), e);
    }

    private void notifyElectionWatchers() {
        for (ElectionWatcher watcher : this.watchers) {
            try {
                watcher.electionResultChanged();
            }
            catch (Exception e) {
                LOG.warn("Election watcher " + watcher + " of type " + watcher.getClass() + " threw an exception.", (Throwable)e);
            }
        }
    }

    public boolean addElectionWatcher(ElectionWatcher e) {
        return this.watchers.add(e);
    }

    public boolean removeElectionWatcher(ElectionWatcher o) {
        return this.watchers.remove(o);
    }

    private class ElectoralMonitorRoute
    extends RouteBuilder {
        private SequenceComparator comparator = new SequenceComparator();
        private ZooKeeperEndpoint zep;

        public ElectoralMonitorRoute(ZooKeeperEndpoint zep) {
            this.zep = zep;
            zep.getConfiguration().setListChildren(true);
            zep.getConfiguration().setSendEmptyMessageOnDelete(true);
            zep.getConfiguration().setRepeat(true);
        }

        public void configure() throws Exception {
            ((RouteDefinition)((RouteDefinition)this.from((Endpoint)this.zep).id("election-route-" + ZooKeeperElection.this.candidateName)).sort((Expression)this.body(), (Comparator)this.comparator)).process(new Processor(){

                public void process(Exchange e) throws Exception {
                    List candidates = (List)e.getIn().getMandatoryBody(List.class);
                    int location = this.findCandidateLocationInCandidatesList(candidates, ZooKeeperElection.this.candidateName);
                    if (location != -1) {
                        ZooKeeperElection.this.masterNode.set(location <= ZooKeeperElection.this.enabledCount);
                        LOG.debug("This node is number '{}' on the candidate list, election is configured for the top '{}'. this node will be {}", new Object[]{location, ZooKeeperElection.this.enabledCount, ZooKeeperElection.this.masterNode.get() ? "enabled" : "disabled"});
                    }
                    ZooKeeperElection.this.electionComplete.countDown();
                    ZooKeeperElection.this.notifyElectionWatchers();
                }

                private int findCandidateLocationInCandidatesList(List<String> candidates, String candidateName) {
                    for (int location = 1; location <= candidates.size(); ++location) {
                        if (!candidates.get(location - 1).startsWith(candidateName)) continue;
                        return location;
                    }
                    return -1;
                }
            });
        }
    }
}

