/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl;

import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.TreeSet;
import org.apache.felix.scr.Component;
import org.apache.felix.scr.Reference;
import org.apache.felix.scr.ScrService;
import org.apache.felix.scr.impl.ComponentRegistry;
import org.apache.felix.scr.impl.ScrShellCommand;
import org.apache.felix.scr.impl.config.ScrConfiguration;
import org.apache.felix.shell.Command;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

class ScrCommand {
    private final BundleContext bundleContext;
    private final ScrService scrService;
    private final ScrConfiguration scrConfiguration;

    static void register(BundleContext bundleContext, ScrService scrService, ScrConfiguration scrConfiguration) {
        ScrCommand cmd = new ScrCommand(bundleContext, scrService, scrConfiguration);
        try {
            String scrGogoCommandClassName = "org.apache.felix.scr.impl.ScrGogoCommand";
            Class<?> scrGogoCommandClass = scrService.getClass().getClassLoader().loadClass("org.apache.felix.scr.impl.ScrGogoCommand");
            Constructor<?> c = scrGogoCommandClass.getConstructor(ScrCommand.class);
            Object gogoCmd = c.newInstance(cmd);
            Hashtable<String, Object> props = new Hashtable<String, Object>();
            props.put("osgi.command.scope", "scr");
            props.put("osgi.command.function", new String[]{"config", "disable", "enable", "info", "list"});
            props.put("service.description", "SCR Gogo Shell Support");
            props.put("service.vendor", "The Apache Software Foundation");
            bundleContext.registerService("org.apache.felix.scr.impl.ScrGogoCommand", gogoCmd, props);
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put("service.description", "SCR Legacy Shell Support");
            props.put("service.vendor", "The Apache Software Foundation");
            bundleContext.registerService(Command.class.getName(), (Object)new ScrShellCommand(cmd), props);
        }
        catch (Throwable th) {
            // empty catch block
        }
    }

    private ScrCommand(BundleContext bundleContext, ScrService scrService, ScrConfiguration scrConfiguration) {
        this.bundleContext = bundleContext;
        this.scrService = scrService;
        this.scrConfiguration = scrConfiguration;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void list(String bundleIdentifier, PrintStream out, PrintStream err) {
        Component[] components;
        if (bundleIdentifier != null) {
            Bundle bundle = null;
            try {
                long bundleId = Long.parseLong(bundleIdentifier);
                bundle = this.bundleContext.getBundle(bundleId);
            }
            catch (NumberFormatException nfe) {
                Bundle[] bundles = this.bundleContext.getBundles();
                for (int i = 0; i < bundles.length; ++i) {
                    if (!bundleIdentifier.equals(bundles[i].getSymbolicName())) continue;
                    bundle = bundles[i];
                    break;
                }
            }
            if (bundle == null) {
                err.println("Missing bundle with ID " + bundleIdentifier);
                return;
            }
            if (!ComponentRegistry.isBundleActive(bundle)) {
                out.println("Bundle " + bundleIdentifier + " is not active");
                return;
            }
            components = this.scrService.getComponents(bundle);
            if (components == null) {
                out.println("Bundle " + bundleIdentifier + " declares no components");
                return;
            }
        } else {
            components = this.scrService.getComponents();
            if (components == null) {
                out.println("No components registered");
                return;
            }
        }
        out.println("   Id   State          Name");
        int i = 0;
        while (i < components.length) {
            out.print('[');
            out.print(this.pad(String.valueOf(components[i].getId()), -4));
            out.print("] [");
            out.print(this.pad(this.toStateString(components[i].getState()), 13));
            out.print("] ");
            out.print(components[i].getName());
            out.println();
            ++i;
        }
        return;
    }

    void info(String componentId, PrintStream out, PrintStream err) {
        Component[] components = this.getComponentFromArg(componentId, err);
        if (components == null) {
            return;
        }
        for (int j = 0; j < components.length; ++j) {
            Dictionary props;
            Reference[] refs;
            String[] services;
            Component component = components[j];
            out.print("ID: ");
            out.println(component.getId());
            out.print("Name: ");
            out.println(component.getName());
            out.print("Bundle: ");
            out.println(component.getBundle().getSymbolicName() + " (" + component.getBundle().getBundleId() + ")");
            out.print("State: ");
            out.println(this.toStateString(component.getState()));
            out.print("Default State: ");
            out.println(component.isDefaultEnabled() ? "enabled" : "disabled");
            out.print("Activation: ");
            out.println(component.isImmediate() ? "immediate" : "delayed");
            out.print("Configuration Policy: ");
            out.println(component.getConfigurationPolicy());
            out.print("Activate Method: ");
            out.print(component.getActivate());
            if (component.isActivateDeclared()) {
                out.print(" (declared in the descriptor)");
            }
            out.println();
            out.print("Deactivate Method: ");
            out.print(component.getDeactivate());
            if (component.isDeactivateDeclared()) {
                out.print(" (declared in the descriptor)");
            }
            out.println();
            out.print("Modified Method: ");
            if (component.getModified() != null) {
                out.print(component.getModified());
            } else {
                out.print("-");
            }
            out.println();
            out.print("Configuration Pid: ");
            out.print(component.getConfigurationPid());
            if (component.isConfigurationPidDeclared()) {
                out.print(" (declared in the descriptor)");
            }
            out.println();
            if (component.getFactory() != null) {
                out.print("Factory: ");
                out.println(component.getFactory());
            }
            if ((services = component.getServices()) != null) {
                out.print("Services: ");
                out.println(services[0]);
                for (int i = 1; i < services.length; ++i) {
                    out.print("          ");
                    out.println(services[i]);
                }
                out.print("Service Type: ");
                out.println(component.isServiceFactory() ? "service factory" : "service");
            }
            if ((refs = component.getReferences()) != null) {
                for (int i = 0; i < refs.length; ++i) {
                    out.print("Reference: ");
                    out.println(refs[i].getName());
                    out.print("    Satisfied: ");
                    out.println(refs[i].isSatisfied() ? "satisfied" : "unsatisfied");
                    out.print("    Service Name: ");
                    out.println(refs[i].getServiceName());
                    if (refs[i].getTarget() != null) {
                        out.print("    Target Filter: ");
                        out.println(refs[i].getTarget());
                    }
                    out.print("    Multiple: ");
                    out.println(refs[i].isMultiple() ? "multiple" : "single");
                    out.print("    Optional: ");
                    out.println(refs[i].isOptional() ? "optional" : "mandatory");
                    out.print("    Policy: ");
                    out.println(refs[i].isStatic() ? "static" : "dynamic");
                    out.print("    Policy option: ");
                    out.println(refs[i].isReluctant() ? "reluctant" : "greedy");
                    ServiceReference[] serviceRefs = refs[i].getBoundServiceReferences();
                    if (serviceRefs == null) continue;
                    out.print("    Bound to:");
                    for (int k = 0; k < serviceRefs.length; ++k) {
                        out.print("        ");
                        out.println(serviceRefs[k]);
                    }
                }
            }
            if ((props = component.getProperties()) == null) continue;
            out.println("Properties:");
            TreeSet keys = new TreeSet(Collections.list(props.keys()));
            for (Object key : keys) {
                out.print("    ");
                out.print(key);
                out.print(" = ");
                Object prop = props.get(key);
                if (prop.getClass().isArray()) {
                    prop = Arrays.asList((Object[])prop);
                }
                out.print(prop);
                out.println();
            }
        }
    }

    void change(String componentIdentifier, PrintStream out, PrintStream err, boolean enable) {
        Component[] components = this.getComponentFromArg(componentIdentifier, err);
        if (components == null) {
            return;
        }
        for (int i = 0; i < components.length; ++i) {
            Component component = components[i];
            if (component.getState() == 256) {
                err.println("Component " + component.getName() + " already disposed, cannot change state");
                continue;
            }
            if (enable) {
                if (component.getState() == 1) {
                    component.enable();
                    out.println("Component " + component.getName() + " enabled");
                    continue;
                }
                out.println("Component " + component.getName() + " already enabled");
                continue;
            }
            if (component.getState() != 1) {
                component.disable();
                out.println("Component " + component.getName() + " disabled");
                continue;
            }
            out.println("Component " + component.getName() + " already disabled");
        }
    }

    void config(PrintStream out) {
        out.print("Log Level: ");
        out.println(this.scrConfiguration.getLogLevel());
        out.print("Component Factory with Factory Configuration: ");
        out.println(this.scrConfiguration.isFactoryEnabled() ? "Supported" : "Unsupported");
    }

    private String pad(String value, int size) {
        boolean right = size < 0;
        int n = size = right ? -size : size;
        if (value.length() >= size) {
            return value;
        }
        char[] buf = new char[size];
        int padLen = size - value.length();
        int valOff = right ? padLen : 0;
        int padOff = right ? 0 : value.length();
        value.getChars(0, value.length(), buf, valOff);
        Arrays.fill(buf, padOff, padOff + padLen, ' ');
        return new String(buf);
    }

    private String toStateString(int state) {
        switch (state) {
            case 1: {
                return "disabled";
            }
            case 4: {
                return "unsatisfied";
            }
            case 16: {
                return "active";
            }
            case 32: {
                return "registered";
            }
            case 64: {
                return "factory";
            }
            case 256: {
                return "disposed";
            }
            case 512: {
                return "enabling";
            }
            case 2: {
                return "enabled";
            }
            case 8: {
                return "activating";
            }
            case 128: {
                return "deactivating";
            }
            case 1024: {
                return "disabling";
            }
            case 2048: {
                return "disposing";
            }
        }
        return String.valueOf(state);
    }

    private Component[] getComponentFromArg(String componentIdentifier, PrintStream err) {
        Component[] components;
        block5: {
            components = null;
            if (componentIdentifier != null) {
                try {
                    long componentId = Long.parseLong(componentIdentifier);
                    Component component = this.scrService.getComponent(componentId);
                    if (component == null) {
                        err.println("Missing Component with ID " + componentId);
                        break block5;
                    }
                    components = new Component[]{component};
                }
                catch (NumberFormatException nfe) {
                    components = this.scrService.getComponents(componentIdentifier);
                    if (components == null) {
                        err.println("Missing Component with ID " + componentIdentifier);
                    }
                    break block5;
                }
            }
            err.println("Component ID required");
        }
        return components;
    }
}

