/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v24.datatype;

import ca.uhn.hl7v2.model.AbstractComposite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v24.datatype.CNN;
import ca.uhn.hl7v2.model.v24.datatype.HD;
import ca.uhn.hl7v2.model.v24.datatype.IS;
import ca.uhn.hl7v2.model.v24.datatype.TS;

public class NDL
extends AbstractComposite {
    private Type[] data;

    public NDL(Message message) {
        super(message);
        this.init();
    }

    private void init() {
        this.data = new Type[11];
        this.data[0] = new CNN(this.getMessage());
        this.data[1] = new TS(this.getMessage());
        this.data[2] = new TS(this.getMessage());
        this.data[3] = new IS(this.getMessage(), 0);
        this.data[4] = new IS(this.getMessage(), 0);
        this.data[5] = new IS(this.getMessage(), 0);
        this.data[6] = new HD(this.getMessage());
        this.data[7] = new IS(this.getMessage(), 0);
        this.data[8] = new IS(this.getMessage(), 0);
        this.data[9] = new IS(this.getMessage(), 0);
        this.data[10] = new IS(this.getMessage(), 0);
    }

    public Type[] getComponents() {
        return this.data;
    }

    public Type getComponent(int number) throws DataTypeException {
        try {
            return this.data[number];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new DataTypeException("Element " + number + " doesn't exist (Type " + ((Object)((Object)this)).getClass().getName() + " has only " + this.data.length + " components)");
        }
    }

    public CNN getOPName() {
        return (CNN)this.getTyped(0, CNN.class);
    }

    public CNN getNdl1_OPName() {
        return (CNN)this.getTyped(0, CNN.class);
    }

    public TS getStartDateTime() {
        return (TS)this.getTyped(1, TS.class);
    }

    public TS getNdl2_StartDateTime() {
        return (TS)this.getTyped(1, TS.class);
    }

    public TS getEndDateTime() {
        return (TS)this.getTyped(2, TS.class);
    }

    public TS getNdl3_EndDateTime() {
        return (TS)this.getTyped(2, TS.class);
    }

    public IS getPointOfCare() {
        return (IS)this.getTyped(3, IS.class);
    }

    public IS getNdl4_PointOfCare() {
        return (IS)this.getTyped(3, IS.class);
    }

    public IS getRoom() {
        return (IS)this.getTyped(4, IS.class);
    }

    public IS getNdl5_Room() {
        return (IS)this.getTyped(4, IS.class);
    }

    public IS getBed() {
        return (IS)this.getTyped(5, IS.class);
    }

    public IS getNdl6_Bed() {
        return (IS)this.getTyped(5, IS.class);
    }

    public HD getFacility() {
        return (HD)this.getTyped(6, HD.class);
    }

    public HD getNdl7_Facility() {
        return (HD)this.getTyped(6, HD.class);
    }

    public IS getLocationStatus() {
        return (IS)this.getTyped(7, IS.class);
    }

    public IS getNdl8_LocationStatus() {
        return (IS)this.getTyped(7, IS.class);
    }

    public IS getPersonLocationType() {
        return (IS)this.getTyped(8, IS.class);
    }

    public IS getNdl9_PersonLocationType() {
        return (IS)this.getTyped(8, IS.class);
    }

    public IS getBuilding() {
        return (IS)this.getTyped(9, IS.class);
    }

    public IS getNdl10_Building() {
        return (IS)this.getTyped(9, IS.class);
    }

    public IS getFloor() {
        return (IS)this.getTyped(10, IS.class);
    }

    public IS getNdl11_Floor() {
        return (IS)this.getTyped(10, IS.class);
    }
}

