/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.CamelContext;
import org.apache.camel.ComponentConfiguration;
import org.apache.camel.Endpoint;
import org.apache.camel.Service;
import org.apache.camel.TypeConverter;
import org.apache.camel.component.salesforce.SalesforceEndpoint;
import org.apache.camel.component.salesforce.SalesforceEndpointConfig;
import org.apache.camel.component.salesforce.SalesforceLoginConfig;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.api.dto.AbstractQueryRecordsBase;
import org.apache.camel.component.salesforce.api.dto.AbstractSObjectBase;
import org.apache.camel.component.salesforce.internal.OperationName;
import org.apache.camel.component.salesforce.internal.SalesforceSession;
import org.apache.camel.component.salesforce.internal.streaming.SubscriptionHelper;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.spi.EndpointCompleter;
import org.apache.camel.util.IntrospectionSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ReflectionHelper;
import org.apache.camel.util.ServiceHelper;
import org.apache.camel.util.jsse.SSLContextParameters;
import org.eclipse.jetty.client.Address;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.RedirectListener;
import org.eclipse.jetty.client.security.Authentication;
import org.eclipse.jetty.client.security.ProxyAuthorization;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SalesforceComponent
extends UriEndpointComponent
implements EndpointCompleter {
    private static final Logger LOG = LoggerFactory.getLogger(SalesforceComponent.class);
    private static final int CONNECTION_TIMEOUT = 60000;
    private static final long RESPONSE_TIMEOUT = 60000L;
    private static final Pattern SOBJECT_NAME_PATTERN = Pattern.compile("^.*[\\?&]sObjectName=([^&,]+).*$");
    private static final String APEX_CALL_PREFIX = OperationName.APEX_CALL.value() + "/";
    private SalesforceLoginConfig loginConfig;
    private SalesforceEndpointConfig config;
    private Map<String, Object> httpClientProperties;
    private SSLContextParameters sslContextParameters;
    private String httpProxyHost;
    private Integer httpProxyPort;
    private String httpProxyUsername;
    private String httpProxyPassword;
    private String[] packages;
    private HttpClient httpClient;
    private SalesforceSession session;
    private Map<String, Class<?>> classMap;
    private SubscriptionHelper subscriptionHelper;

    public SalesforceComponent() {
        super(SalesforceEndpoint.class);
    }

    public SalesforceComponent(CamelContext context) {
        super(context, SalesforceEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        OperationName operationName = null;
        String topicName = null;
        String apexUrl = null;
        try {
            LOG.debug("Creating endpoint for: {}", (Object)remaining);
            if (remaining.startsWith(APEX_CALL_PREFIX)) {
                apexUrl = remaining.substring(APEX_CALL_PREFIX.length());
                remaining = OperationName.APEX_CALL.value();
            }
            operationName = OperationName.fromValue(remaining);
        }
        catch (IllegalArgumentException ex) {
            topicName = remaining;
        }
        if (this.config == null) {
            this.config = new SalesforceEndpointConfig();
        }
        if (this.config.getHttpClient() == null) {
            this.config.setHttpClient(this.httpClient);
        }
        SalesforceEndpointConfig copy = this.config.copy();
        this.setProperties(copy, parameters);
        if (apexUrl != null) {
            copy.setApexUrl(apexUrl);
        }
        SalesforceEndpoint endpoint = new SalesforceEndpoint(uri, this, copy, operationName, topicName);
        this.setProperties((Object)endpoint, parameters);
        if (operationName == OperationName.APEX_CALL && !parameters.isEmpty()) {
            HashMap<String, Object> queryParams = new HashMap<String, Object>(copy.getApexQueryParams());
            queryParams.putAll(parameters);
            parameters.clear();
            copy.setApexQueryParams(queryParams);
        }
        return endpoint;
    }

    private Map<String, Class<?>> parsePackages() {
        HashMap result = new HashMap();
        Set classes = this.getCamelContext().getPackageScanClassResolver().findImplementations(AbstractSObjectBase.class, this.packages);
        for (Class aClass : classes) {
            if (AbstractSObjectBase.class == aClass) continue;
            result.put(aClass.getSimpleName(), aClass);
        }
        return result;
    }

    protected void doStart() throws Exception {
        ObjectHelper.notNull((Object)this.loginConfig, (String)"loginConfig");
        if (null == this.httpClient) {
            if (this.config != null && this.config.getHttpClient() != null) {
                this.httpClient = this.config.getHttpClient();
            } else {
                this.httpClient = new HttpClient();
                this.httpClient.setConnectorType(2);
                this.httpClient.setConnectTimeout(60000);
                this.httpClient.setTimeout(60000L);
            }
        }
        SSLContextParameters contextParameters = this.sslContextParameters != null ? this.sslContextParameters : new SSLContextParameters();
        SslContextFactory sslContextFactory = this.httpClient.getSslContextFactory();
        sslContextFactory.setSslContext(contextParameters.createSSLContext());
        if (this.httpClientProperties != null && !this.httpClientProperties.isEmpty()) {
            IntrospectionSupport.setProperties((TypeConverter)this.getCamelContext().getTypeConverter(), (Object)this.httpClient, new HashMap<String, Object>(this.httpClientProperties));
        }
        if (this.httpProxyHost != null && this.httpProxyPort != null) {
            this.httpClient.setProxy(new Address(this.httpProxyHost, this.httpProxyPort.intValue()));
        }
        if (this.httpProxyUsername != null && this.httpProxyPassword != null) {
            this.httpClient.setProxyAuthentication((Authentication)new ProxyAuthorization(this.httpProxyUsername, this.httpProxyPassword));
        }
        String listenerClass = RedirectListener.class.getName();
        if (this.httpClient.getRegisteredListeners() == null || !this.httpClient.getRegisteredListeners().contains(listenerClass)) {
            this.httpClient.registerListener(listenerClass);
        }
        this.httpClient.start();
        if (null == this.session) {
            this.session = new SalesforceSession(this.httpClient, this.loginConfig);
        }
        if (!this.loginConfig.isLazyLogin()) {
            ServiceHelper.startService((Service)this.session);
        }
        if (this.packages != null && this.packages.length > 0) {
            this.classMap = this.parsePackages();
            LOG.info("Found {} generated classes in packages: {}", (Object)this.classMap.size(), Arrays.asList(this.packages));
        } else {
            LOG.warn("Missing property packages, getSObject* operations will NOT work");
            this.classMap = new HashMap(0);
        }
        if (this.subscriptionHelper != null) {
            ServiceHelper.startService((Service)this.subscriptionHelper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        if (this.classMap != null) {
            this.classMap.clear();
        }
        try {
            if (this.subscriptionHelper != null) {
                ServiceHelper.stopService((Object)((Object)this.subscriptionHelper));
                this.subscriptionHelper = null;
            }
            if (this.session != null && this.session.getAccessToken() != null) {
                try {
                    ServiceHelper.stopService((Object)this.session);
                }
                catch (SalesforceException salesforceException) {
                    // empty catch block
                }
            }
        }
        finally {
            if (this.httpClient != null) {
                this.httpClient.stop();
                if (this.config.getHttpClient() == null) {
                    this.httpClient.destroy();
                }
                this.httpClient = null;
            }
        }
    }

    public SubscriptionHelper getSubscriptionHelper() throws Exception {
        if (this.subscriptionHelper == null) {
            this.subscriptionHelper = new SubscriptionHelper(this);
            ServiceHelper.startService((Service)this.subscriptionHelper);
        }
        return this.subscriptionHelper;
    }

    public List<String> completeEndpointPath(ComponentConfiguration configuration, String completionText) {
        final ArrayList<String> result = new ArrayList<String>();
        boolean empty = ObjectHelper.isEmpty((Object)completionText);
        if (empty || completionText.indexOf(63) == -1) {
            OperationName[] values;
            if (empty) {
                completionText = "";
            }
            for (OperationName val : values = OperationName.values()) {
                String strValue = val.value();
                if (!strValue.startsWith(completionText)) continue;
                result.add(strValue);
            }
            if (empty) {
                result.add("[PushTopicName]");
            }
        } else if (completionText.matches("^.*[\\?&]sObjectName=$")) {
            result.addAll(this.classMap.keySet());
        } else if (completionText.matches("^.*[\\?&]sObjectFields=$")) {
            Matcher matcher;
            String sObjectName = (String)configuration.getParameter("sObjectName");
            if (sObjectName == null && (matcher = SOBJECT_NAME_PATTERN.matcher(completionText)).matches()) {
                sObjectName = matcher.group(1);
            }
            if (sObjectName != null) {
                Class<?> aClass = this.classMap.get(sObjectName);
                ReflectionHelper.doWithFields(aClass, (ReflectionHelper.FieldCallback)new ReflectionHelper.FieldCallback(){

                    public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                        if ((field.getModifiers() & 8) == 0) {
                            result.add(field.getName());
                        }
                    }
                });
            }
        } else if (completionText.matches("^.*[\\?&]sObjectClass=$")) {
            for (Class<?> c : this.classMap.values()) {
                result.add(c.getName());
            }
            Set classes = this.getCamelContext().getPackageScanClassResolver().findImplementations(AbstractQueryRecordsBase.class, this.packages);
            for (Class aClass : classes) {
                if (AbstractQueryRecordsBase.class == aClass) continue;
                result.add(aClass.getName());
            }
        }
        return result;
    }

    public SalesforceLoginConfig getLoginConfig() {
        return this.loginConfig;
    }

    public void setLoginConfig(SalesforceLoginConfig loginConfig) {
        this.loginConfig = loginConfig;
    }

    public SalesforceEndpointConfig getConfig() {
        return this.config;
    }

    public void setConfig(SalesforceEndpointConfig config) {
        this.config = config;
    }

    public Map<String, Object> getHttpClientProperties() {
        return this.httpClientProperties;
    }

    public void setHttpClientProperties(Map<String, Object> httpClientProperties) {
        this.httpClientProperties = httpClientProperties;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public String getHttpProxyHost() {
        return this.httpProxyHost;
    }

    public void setHttpProxyHost(String httpProxyHost) {
        this.httpProxyHost = httpProxyHost;
    }

    public Integer getHttpProxyPort() {
        return this.httpProxyPort;
    }

    public void setHttpProxyPort(Integer httpProxyPort) {
        this.httpProxyPort = httpProxyPort;
    }

    public String getHttpProxyUsername() {
        return this.httpProxyUsername;
    }

    public void setHttpProxyUsername(String httpProxyUsername) {
        this.httpProxyUsername = httpProxyUsername;
    }

    public String getHttpProxyPassword() {
        return this.httpProxyPassword;
    }

    public void setHttpProxyPassword(String httpProxyPassword) {
        this.httpProxyPassword = httpProxyPassword;
    }

    public String[] getPackages() {
        return this.packages;
    }

    public void setPackages(String[] packages) {
        this.packages = packages;
    }

    public void setPackages(String packages) {
        if (packages != null) {
            this.setPackages(packages.split(","));
        }
    }

    public SalesforceSession getSession() {
        return this.session;
    }

    public Map<String, Class<?>> getClassMap() {
        return this.classMap;
    }
}

