/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.undertow;

import io.undertow.server.HttpHandler;
import java.net.URI;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.undertow.UndertowEndpoint;
import org.apache.camel.component.undertow.UndertowHost;
import org.apache.camel.component.undertow.handlers.HttpCamelHandler;
import org.apache.camel.impl.DefaultConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UndertowConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(UndertowConsumer.class);
    private UndertowHost undertowHost;

    public UndertowConsumer(UndertowEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
    }

    public UndertowEndpoint getEndpoint() {
        return (UndertowEndpoint)super.getEndpoint();
    }

    public UndertowHost getUndertowHost() {
        if (this.undertowHost == null) {
            this.undertowHost = this.createUndertowHost();
        }
        return this.undertowHost;
    }

    protected UndertowHost createUndertowHost() {
        return new DefaultUndertowHost();
    }

    protected void doStart() throws Exception {
        super.doStart();
        LOG.debug("Undertow consumer is starting");
        this.getEndpoint().getComponent().registerConsumer(this);
        URI httpUri = this.getEndpoint().getHttpURI();
        UndertowHost host = this.getUndertowHost();
        host.validateEndpointURI(httpUri);
        host.registerHandler(httpUri.getPath(), new HttpCamelHandler(this));
    }

    protected void doStop() {
        LOG.debug("Undertow consumer is stopping");
        URI httpUri = this.getEndpoint().getHttpURI();
        UndertowHost host = this.getUndertowHost();
        host.unregisterHandler(httpUri.getPath());
        this.getEndpoint().getComponent().unregisterConsumer(this);
    }

    class DefaultUndertowHost
    implements UndertowHost {
        DefaultUndertowHost() {
        }

        @Override
        public void validateEndpointURI(URI httpURI) {
        }

        @Override
        public void registerHandler(String path, HttpHandler handler) {
            UndertowConsumer.this.getEndpoint().getComponent().startServer(UndertowConsumer.this);
        }

        @Override
        public void unregisterHandler(String path) {
        }
    }
}

