/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.zipfile;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.dataformat.zipfile.ZipIterator;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StringHelper;

public class ZipFileDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName {
    private boolean usingIterator;

    public String getDataFormatName() {
        return "zipFile";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void marshal(Exchange exchange, Object graph, OutputStream stream) throws Exception {
        String filename = (String)exchange.getIn().getHeader("CamelFileName", String.class);
        filename = filename != null ? new File(filename).getName() : StringHelper.sanitize((String)exchange.getIn().getMessageId());
        ZipOutputStream zos = new ZipOutputStream(stream);
        zos.putNextEntry(new ZipEntry(filename));
        InputStream is = (InputStream)exchange.getContext().getTypeConverter().mandatoryConvertTo(InputStream.class, exchange, graph);
        try {
            IOHelper.copy((InputStream)is, (OutputStream)zos);
        }
        catch (Throwable throwable) {
            IOHelper.close((Closeable[])new Closeable[]{is, zos});
            throw throwable;
        }
        IOHelper.close((Closeable[])new Closeable[]{is, zos});
        String newFilename = filename + ".zip";
        exchange.getOut().setHeader("CamelFileName", (Object)newFilename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object unmarshal(Exchange exchange, InputStream stream) throws Exception {
        byte[] byArray;
        if (this.usingIterator) {
            return new ZipIterator(exchange.getIn());
        }
        InputStream is = (InputStream)exchange.getIn().getMandatoryBody(InputStream.class);
        ZipInputStream zis = new ZipInputStream(is);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ZipEntry entry = zis.getNextEntry();
            if (entry != null) {
                exchange.getOut().setHeader("CamelFileName", (Object)entry.getName());
                IOHelper.copy((InputStream)zis, (OutputStream)baos);
            }
            if ((entry = zis.getNextEntry()) != null) {
                throw new IllegalStateException("Zip file has more than 1 entry.");
            }
            byArray = baos.toByteArray();
        }
        catch (Throwable throwable) {
            IOHelper.close((Closeable[])new Closeable[]{zis, baos});
            throw throwable;
        }
        IOHelper.close((Closeable[])new Closeable[]{zis, baos});
        return byArray;
    }

    public boolean isUsingIterator() {
        return this.usingIterator;
    }

    public void setUsingIterator(boolean usingIterator) {
        this.usingIterator = usingIterator;
    }

    protected void doStart() throws Exception {
    }

    protected void doStop() throws Exception {
    }
}

