/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.camel.security;

import java.util.HashSet;
import java.util.Set;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.wildfly.extension.camel.security.AbstractAuthorizationPolicy;
import org.wildfly.extension.camel.security.LoginContextBuilder;

public class DomainAuthorizationPolicy
extends AbstractAuthorizationPolicy {
    private final Set<String> roles = new HashSet<String>();

    public DomainAuthorizationPolicy roles(String ... roles) {
        for (String role : roles) {
            this.roles.add(role);
        }
        return this;
    }

    @Override
    protected LoginContext getLoginContext(String domain, String username, char[] password) throws LoginException {
        String[] rolesArr = this.roles.toArray(new String[this.roles.size()]);
        LoginContextBuilder builder = new LoginContextBuilder(LoginContextBuilder.Type.AUTHENTICATION).domain(domain);
        return builder.username(username).password(password).roles(rolesArr).build();
    }
}

