/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hl7;

import ca.uhn.hl7v2.AcknowledgmentCode;
import ca.uhn.hl7v2.ErrorCode;
import ca.uhn.hl7v2.HapiContext;
import ca.uhn.hl7v2.validation.ValidationContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.hl7.AckCode;
import org.apache.camel.component.hl7.AckExpression;
import org.apache.camel.component.hl7.TerserExpression;
import org.apache.camel.component.hl7.ValidationContextPredicate;
import org.apache.camel.support.ExpressionAdapter;

public final class HL7 {
    private HL7() {
    }

    public static ValueBuilder terser(String expression) {
        return new ValueBuilder((Expression)new TerserExpression(expression));
    }

    public static ValueBuilder ack() {
        return new ValueBuilder((Expression)new AckExpression());
    }

    @Deprecated
    public static ValueBuilder ack(AckCode code) {
        return new ValueBuilder((Expression)new AckExpression(code));
    }

    public static ValueBuilder ack(AcknowledgmentCode code) {
        return new ValueBuilder((Expression)new AckExpression(code));
    }

    public static ValueBuilder convertLFToCR() {
        return new ValueBuilder((Expression)new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                String s = (String)exchange.getIn().getBody(String.class);
                return s != null ? s.replace('\n', '\r') : null;
            }
        });
    }

    @Deprecated
    public static ValueBuilder ack(AckCode code, String errorMessage, int errorCode) {
        return HL7.ack(code.toAcknowledgmentCode(), errorMessage, ErrorCode.errorCodeFor((int)errorCode));
    }

    @Deprecated
    public static ValueBuilder ack(AckCode code, String errorMessage, ErrorCode errorCode) {
        return HL7.ack(code.toAcknowledgmentCode(), errorMessage, errorCode);
    }

    public static ValueBuilder ack(AcknowledgmentCode code, String errorMessage, ErrorCode errorCode) {
        return new ValueBuilder((Expression)new AckExpression(code, errorMessage, errorCode));
    }

    public static Predicate messageConforms() {
        return new ValidationContextPredicate();
    }

    public static Predicate messageConformsTo(HapiContext hapiContext) {
        return new ValidationContextPredicate(hapiContext);
    }

    public static Predicate messageConformsTo(ValidationContext validationContext) {
        return new ValidationContextPredicate(validationContext);
    }

    public static Predicate messageConformsTo(Expression expression) {
        return new ValidationContextPredicate(expression);
    }
}

