/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.util;

import ca.uhn.hl7v2.util.Home;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageIDGenerator {
    private static final Logger ourLog = LoggerFactory.getLogger((String)MessageIDGenerator.class.getName());
    private static MessageIDGenerator messageIdGenerator;
    public static final String DEFAULT_ID_FILE;
    public static final String NEVER_FAIL_PROPERTY;
    private long id;
    private FileWriter fileW;

    private MessageIDGenerator() throws IOException {
        this.initialize();
    }

    void initialize() throws IOException {
        block9: {
            this.id = 0L;
            try {
                File extFile = new File(DEFAULT_ID_FILE);
                if (extFile.createNewFile()) {
                    this.id = 0L;
                    break block9;
                }
                FileReader fileR = new FileReader(DEFAULT_ID_FILE);
                char[] charArray = new char[100];
                int e = fileR.read(charArray);
                if (e <= 0) {
                    this.id = 0L;
                } else {
                    String idStr = String.valueOf(charArray);
                    String idStrTrim = idStr.trim();
                    try {
                        this.id = Long.parseLong(idStrTrim);
                    }
                    catch (NumberFormatException nfe) {
                        ourLog.warn("Failed to parse message ID file value \"" + idStrTrim + "\". Defaulting to 0.");
                    }
                }
                fileR.close();
            }
            catch (FileNotFoundException e) {
                ourLog.error("Failed to locate message ID file. Message was: {}", (Object)e.getMessage());
            }
            catch (IOException e) {
                if (Boolean.TRUE.equals(System.getProperty(NEVER_FAIL_PROPERTY, Boolean.TRUE.toString()))) {
                    ourLog.warn("Could not retrieve message ID file, going to default to ID of 0. Message was: {}", (Object)e.getMessage());
                    this.id = 0L;
                    return;
                }
                throw e;
            }
        }
    }

    public static synchronized MessageIDGenerator getInstance() throws IOException {
        if (messageIdGenerator == null) {
            messageIdGenerator = new MessageIDGenerator();
        }
        return messageIdGenerator;
    }

    public synchronized String getNewID() throws IOException {
        try {
            ++this.id;
            String idStr = String.valueOf(this.id);
            this.fileW = new FileWriter(DEFAULT_ID_FILE, false);
            this.fileW.write(idStr);
            this.fileW.flush();
            this.fileW.close();
        }
        catch (FileNotFoundException e) {
            if (Boolean.TRUE.equals(System.getProperty(NEVER_FAIL_PROPERTY, Boolean.TRUE.toString()))) {
                ourLog.info("Failed to create message ID file. Message was: {}", (Object)e.getMessage());
                this.fileW = null;
            }
        }
        catch (IOException e) {
            if (Boolean.TRUE.equals(System.getProperty(NEVER_FAIL_PROPERTY, Boolean.TRUE.toString()))) {
                ourLog.debug("Failed to create message ID file. Message was: {}", (Object)e.getMessage());
                this.fileW = null;
            }
            throw e;
        }
        return String.valueOf(this.id);
    }

    static {
        DEFAULT_ID_FILE = Home.getHomeDirectory().getAbsolutePath() + "/id_file";
        NEVER_FAIL_PROPERTY = MessageIDGenerator.class.getName() + "_NEVER_FAIL_PROPERTY";
    }
}

